/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.api.util;

import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class VoxelShapeUtil {
    public static VoxelShape rotate(VoxelShape shape, Direction newDir) {
        return VoxelShapeUtil.rotate(shape, Direction.NORTH, newDir);
    }

    public static VoxelShape rotate(VoxelShape shape, Direction originalDir, Direction newDir) {
        if (originalDir != newDir) {
            VoxelShape[] newShape = new VoxelShape[]{Shapes.m_83040_()};
            shape.m_83286_((x, y, z, a, b, c) -> {
                double i = 1.0 - c;
                double j = 1.0 - z;
                newShape[0] = Shapes.m_83110_((VoxelShape)newShape[0], (VoxelShape)Shapes.m_83048_((double)Math.min(i, j), (double)y, (double)x, (double)Math.max(i, j), (double)b, (double)a));
            });
            return VoxelShapeUtil.rotate(newShape[0], originalDir.m_122427_(), newDir);
        }
        return shape;
    }

    public static VoxelShape mirror(VoxelShape shape, Direction facingProperty) {
        return VoxelShapeUtil.mirror(shape, facingProperty.m_122434_());
    }

    public static VoxelShape mirror(VoxelShape shape, Mirror mirror) {
        return VoxelShapeUtil.mirror(shape, mirror == Mirror.FRONT_BACK ? Direction.Axis.X : Direction.Axis.Z);
    }

    public static VoxelShape mirror(VoxelShape shape, Direction.Axis axis) {
        VoxelShape[] newShape = new VoxelShape[]{Shapes.m_83040_()};
        switch (axis) {
            case X: {
                shape.m_83286_((x, y, z, a, b, c) -> {
                    double i = 1.0 - x;
                    double j = 1.0 - a;
                    newShape[0] = Shapes.m_83110_((VoxelShape)newShape[0], (VoxelShape)Shapes.m_83048_((double)Math.min(i, j), (double)y, (double)z, (double)Math.max(i, j), (double)b, (double)c));
                });
                break;
            }
            case Z: {
                shape.m_83286_((x, y, z, a, b, c) -> {
                    double i = 1.0 - z;
                    double j = 1.0 - c;
                    newShape[0] = Shapes.m_83110_((VoxelShape)newShape[0], (VoxelShape)Shapes.m_83048_((double)x, (double)y, (double)Math.min(i, j), (double)a, (double)b, (double)Math.max(i, j)));
                });
                break;
            }
            case Y: {
                shape.m_83286_((x, y, z, a, b, c) -> {
                    double i = 1.0 - y;
                    double j = 1.0 - b;
                    newShape[0] = Shapes.m_83110_((VoxelShape)newShape[0], (VoxelShape)Shapes.m_83048_((double)x, (double)Math.min(i, j), (double)z, (double)a, (double)Math.max(i, j), (double)c));
                });
            }
        }
        return newShape[0];
    }
}

