/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core;

import com.legacy.structure_gel.api.config.ConfigBuilder;
import com.legacy.structure_gel.core.util.Internal;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

@Internal
public class SGConfig {
    public static final Common COMMON;
    public static final Client CLIENT;
    protected static final ForgeConfigSpec COMMON_SPEC;
    protected static final ForgeConfigSpec CLIENT_SPEC;

    static {
        Pair specPairCommon = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)specPairCommon.getRight();
        COMMON = (Common)specPairCommon.getLeft();
        Pair specPairClient = new ForgeConfigSpec.Builder().configure(Client::new);
        CLIENT_SPEC = (ForgeConfigSpec)specPairClient.getRight();
        CLIENT = (Client)specPairClient.getLeft();
    }

    public static class Common {
        private final ForgeConfigSpec.IntValue buildingToolMaxUndos;
        private final ForgeConfigSpec.BooleanValue exceedFillLimit;
        private final ForgeConfigSpec.BooleanValue consoleDebug;
        private final ForgeConfigSpec.BooleanValue advancedGelBehavior;

        public Common(ForgeConfigSpec.Builder builder) {
            builder.push("building_tool");
            this.buildingToolMaxUndos = ConfigBuilder.makeInt(builder, "max_undos", "The amount of undo operations saved by the Building Tool.", 32, 8, 256);
            builder.pop();
            builder.push("vanilla_enhancements");
            this.exceedFillLimit = ConfigBuilder.makeBoolean(builder, "exceed_fill_and_clone_limit", "When true, removes the size limit from the fill and clone commands.", true);
            builder.pop();
            builder.push("debug");
            this.consoleDebug = ConfigBuilder.makeBoolean(builder, "console_debug", "When true, allows extra debug logging to be printed to the console.", false);
            this.advancedGelBehavior = ConfigBuilder.makeBoolean(builder, "advanced_gel_behavior", "When true:\n - Gel blocks can be clicked through like air when holding items that don't interact with them.\n - Gel blocks can be replaced like air when not holding gel or crouching.\n - Gel blocks automatically replace destroyed neighboring blocks.", true);
            builder.pop();
        }

        public int getBuildingToolMaxUndos() {
            return (Integer)this.buildingToolMaxUndos.get();
        }

        public boolean shouldExceedFillLimit() {
            return (Boolean)this.exceedFillLimit.get();
        }

        public boolean consoleDebug() {
            return (Boolean)this.consoleDebug.get();
        }

        public boolean advancedGelBehavior() {
            return (Boolean)this.advancedGelBehavior.get();
        }
    }

    public static class Client {
        private final ForgeConfigSpec.BooleanValue showStructureBlockInfo;
        private final ForgeConfigSpec.BooleanValue threadBuildingTool;

        public Client(ForgeConfigSpec.Builder builder) {
            builder.push("rendering");
            this.showStructureBlockInfo = ConfigBuilder.makeBoolean(builder, "show_structure_block_info", "Displays info on top of Structure Blocks and Jigsaws in world.", true);
            this.threadBuildingTool = ConfigBuilder.makeBoolean(builder, "thread_building_tool", "Makes the render used by the Building Tool operate in a threaded context.", true);
            builder.pop();
        }

        public boolean showStructureBlockInfo() {
            return (Boolean)this.showStructureBlockInfo.get();
        }

        public boolean threadBuildingTool() {
            return (Boolean)this.threadBuildingTool.get();
        }
    }
}

