/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.block_entity;

import com.legacy.structure_gel.api.data_handler.DataHandlerType;
import com.legacy.structure_gel.api.data_handler.handlers.DataHandler;
import com.legacy.structure_gel.core.StructureGelMod;
import com.legacy.structure_gel.core.block_entity.SGBlockEntity;
import com.legacy.structure_gel.core.registry.SGRegistry;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.Weight;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.level.block.state.BlockState;

public class DataHandlerBlockEntity
extends SGBlockEntity {
    public static final String HANDLERS_KEY = "handlers";
    private WeightedRandomList<RawHandler> handlers = WeightedRandomList.m_146332_();

    public DataHandlerBlockEntity(BlockPos pos, BlockState state) {
        super(SGRegistry.BlockEntities.DATA_HANDLER.get(), pos, state);
    }

    public WeightedRandomList<RawHandler> getHandlers() {
        return this.handlers;
    }

    public void setHandlers(WeightedRandomList<RawHandler> handlers) {
        this.handlers = handlers;
        this.m_6596_();
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        ListTag listTag = new ListTag();
        for (RawHandler handler : this.handlers.m_146338_()) {
            CompoundTag handlerTag = new CompoundTag();
            handler.trySave(handlerTag);
            listTag.add((Object)handlerTag);
        }
        tag.m_128365_(HANDLERS_KEY, (Tag)listTag);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.handlers = DataHandlerBlockEntity.loadAllHandlers(tag);
    }

    public static WeightedRandomList<RawHandler> loadAllHandlers(CompoundTag tag) {
        ArrayList<RawHandler> handlers = new ArrayList<RawHandler>();
        Optional<RawHandler> legacyHandler = RawHandler.tryLoad(tag);
        if (legacyHandler.isPresent()) {
            handlers.add(legacyHandler.get());
        }
        handlers.addAll(DataHandlerBlockEntity.readHandlerList(tag));
        return WeightedRandomList.m_146328_(handlers);
    }

    private static List<RawHandler> readHandlerList(CompoundTag tag) {
        ArrayList<RawHandler> handlerList = new ArrayList<RawHandler>();
        if (tag.m_128425_(HANDLERS_KEY, 9)) {
            ListTag listTag = tag.m_128437_(HANDLERS_KEY, 10);
            for (Tag t : listTag) {
                CompoundTag handlerTag;
                Optional<RawHandler> handler;
                if (!(t instanceof CompoundTag) || !(handler = RawHandler.tryLoad(handlerTag = (CompoundTag)t)).isPresent()) continue;
                handlerList.add(handler.get());
            }
        }
        return handlerList;
    }

    public record RawHandler(Weight weight, ResourceLocation typeName, LinkedHashMap<String, String> dataEntries) implements WeightedEntry
    {
        public static final RawHandler EMPTY = new RawHandler(Weight.m_146282_((int)1), new ResourceLocation(""), new LinkedHashMap<String, String>());
        public static final String WEIGHT_KEY = "weight";
        public static final String TYPE_KEY = "type";
        public static final String ENTRIES_KEY = "entries";

        public static Optional<RawHandler> tryLoad(CompoundTag tag) {
            ResourceLocation type = RawHandler.readType(tag);
            if (type == null) {
                return Optional.empty();
            }
            int weight = tag.m_128425_(WEIGHT_KEY, 3) ? tag.m_128451_(WEIGHT_KEY) : 1;
            LinkedHashMap<String, String> data = RawHandler.readDataEntries(tag);
            return Optional.of(new RawHandler(Weight.m_146282_((int)weight), type, data));
        }

        @Nullable
        private static ResourceLocation readType(CompoundTag tag) {
            String str;
            if (tag.m_128425_(TYPE_KEY, 8) && ResourceLocation.m_135830_((String)(str = tag.m_128461_(TYPE_KEY)))) {
                return new ResourceLocation(str);
            }
            return null;
        }

        private static LinkedHashMap<String, String> readDataEntries(CompoundTag tag) {
            LinkedHashMap<String, String> entries = new LinkedHashMap<String, String>();
            CompoundTag dataTag = tag.m_128469_(ENTRIES_KEY);
            for (String key : dataTag.m_128431_()) {
                entries.put(key, dataTag.m_128461_(key));
            }
            return entries;
        }

        public void trySave(CompoundTag tag) {
            if (this.typeName.m_135815_().isEmpty()) {
                return;
            }
            if (this.weight.m_146281_() != 1) {
                tag.m_128405_(WEIGHT_KEY, this.weight.m_146281_());
            }
            if (this.typeName != null) {
                tag.m_128359_(TYPE_KEY, this.typeName.toString());
            }
            CompoundTag dataTag = new CompoundTag();
            for (Map.Entry<String, String> entry : this.dataEntries.entrySet()) {
                String value = entry.getValue();
                if (value.isEmpty()) continue;
                dataTag.m_128359_(entry.getKey(), entry.getValue());
            }
            tag.m_128365_(ENTRIES_KEY, (Tag)dataTag);
        }

        @Nullable
        public DataHandler<?> tryBake(BlockPos pos) {
            try {
                if (this.typeName != null) {
                    DataHandlerType<?> type = DataHandlerType.REGISTRY.get(this.typeName);
                    if (type != null) {
                        return type.create(type.getDataParser().parse(this.dataEntries));
                    }
                    StructureGelMod.LOGGER.error("{} is not a registered DataHandlerType", this.typeName);
                } else {
                    StructureGelMod.LOGGER.error("\type\" was null for the DataHandlerBlockEntity at {}", pos);
                }
            }
            catch (Exception e) {
                StructureGelMod.LOGGER.error("Couldn't deserialize DataHandler from {}", pos);
                StructureGelMod.LOGGER.error(e, new Object[0]);
            }
            return null;
        }

        public Weight m_142631_() {
            return this.weight;
        }
    }
}

