/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.client.renderers;

import com.legacy.structure_gel.core.SGConfig;
import com.legacy.structure_gel.core.client.renderers.BuildingToolRenderers;
import com.legacy.structure_gel.core.client.renderers.IRenderBase;
import com.legacy.structure_gel.core.item.building_tool.BuildingToolItem;
import com.legacy.structure_gel.core.item.building_tool.BuildingToolMode;
import com.legacy.structure_gel.core.item.building_tool.BuildingToolModes;
import com.legacy.structure_gel.core.item.building_tool.SmartBoundingBox;
import com.legacy.structure_gel.core.registry.SGRegistry;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public abstract class BuildingToolRenderer
implements IRenderBase {
    protected static final Map<BuildingToolMode, Supplier<BuildingToolRenderer>> RENDERERS = new HashMap<BuildingToolMode, Supplier<BuildingToolRenderer>>();
    @Nullable
    protected static BuildingToolMode currentMode = null;
    @Nullable
    private static BuildingToolRenderer instance = null;
    private static boolean shouldClear = false;
    @Nullable
    protected BlockPos pos;
    @Nullable
    protected BlockPos hitPos;
    @Nullable
    protected Direction hitFace;
    @Nullable
    protected Vec3 hitVec;
    protected boolean hitBlock = false;
    @Nullable
    private VertexBuffer lineBuffer;
    protected boolean needsCompiled = true;
    protected Vec3i renderPos = Vec3i.f_123288_;
    private final Tesselator tesselator = new Tesselator();
    @Nullable
    private CompletableFuture<RenderResult> futureRender = null;
    private RenderInfo lastRenderInfo = new RenderInfo();

    protected BuildingToolRenderer() {
    }

    private static void updateRenderedMode(@Nullable ItemStack stack) {
        BuildingToolMode newMode;
        BuildingToolMode buildingToolMode = newMode = stack != null && stack.m_150930_((Item)SGRegistry.Items.BUILDING_TOOL.get()) ? BuildingToolItem.getMode(stack) : null;
        if (currentMode != newMode) {
            currentMode = newMode;
            if (instance != null) {
                instance.close();
            }
            instance = currentMode == null ? null : RENDERERS.getOrDefault(currentMode, () -> null).get();
        }
    }

    public static void render(Minecraft mc, PoseStack poseStack, Matrix4f projectionMatrix, double camX, double camY, double camZ) {
        LocalPlayer player;
        if (shouldClear) {
            shouldClear = false;
            if (instance != null) {
                instance.close();
            }
            instance = null;
        }
        if ((player = mc.f_91074_) != null && player.m_7500_()) {
            Pair<InteractionHand, ItemStack> tool = BuildingToolItem.getBuildingTool((Player)player);
            if (tool == null) {
                BuildingToolRenderer.updateRenderedMode(null);
                return;
            }
            ItemStack toolStack = (ItemStack)tool.getSecond();
            BuildingToolRenderer.updateRenderedMode(toolStack);
            if (instance != null && !toolStack.m_41619_()) {
                instance.updateData(mc, toolStack);
                Vec3i camPos = new Vec3i(camX, camY, camZ);
                if (instance.shouldRender(camPos)) {
                    poseStack.m_85836_();
                    poseStack.m_85837_(-camX, -camY, -camZ);
                    if (BuildingToolRenderer.instance.needsCompiled && BuildingToolRenderer.instance.compile((Minecraft)mc, (LocalPlayer)player, (ItemStack)toolStack, (double)camX, (double)camY, (double)camZ).isFinished) {
                        BuildingToolRenderer.instance.needsCompiled = false;
                    }
                    instance.render(mc, player, toolStack, poseStack, projectionMatrix, camX, camY, camZ);
                    poseStack.m_85849_();
                }
            }
        }
    }

    protected RenderInfo compile(Minecraft mc, LocalPlayer player, ItemStack stack, double camX, double camY, double camZ) {
        if (SGConfig.CLIENT.threadBuildingTool()) {
            if (this.futureRender == null) {
                this.lastRenderInfo.isFinished = false;
                this.futureRender = CompletableFuture.supplyAsync(() -> {
                    BufferBuilder buffBuilder = this.tesselator.m_85915_();
                    buffBuilder.m_166779_(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.f_85815_);
                    RenderInfo renderInfo = new RenderInfo();
                    this.compileInfo(mc, stack, buffBuilder, camX, camY, camZ, renderInfo);
                    return new RenderResult(renderInfo, buffBuilder);
                }, Util.m_183991_());
            }
            if (this.futureRender != null && this.futureRender.isDone()) {
                try {
                    RenderResult result = this.futureRender.get();
                    result.renderInfo().isFinished = true;
                    this.renderPos = result.renderInfo().renderPos;
                    if (this.lineBuffer != null) {
                        this.lineBuffer.close();
                    }
                    this.lineBuffer = new VertexBuffer();
                    this.lineBuffer.m_85921_();
                    this.lineBuffer.m_231221_(result.buffBuilder().m_231175_());
                    this.futureRender = null;
                    VertexBuffer.m_85931_();
                    this.lastRenderInfo = result.renderInfo();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        } else {
            BufferBuilder buffBuilder = Tesselator.m_85913_().m_85915_();
            buffBuilder.m_166779_(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.f_85815_);
            RenderInfo renderInfo = new RenderInfo();
            this.compileInfo(mc, stack, buffBuilder, camX, camY, camZ, renderInfo);
            this.renderPos = renderInfo.renderPos;
            if (this.lineBuffer != null) {
                this.lineBuffer.close();
            }
            this.lineBuffer = new VertexBuffer();
            this.lineBuffer.m_85921_();
            this.lineBuffer.m_231221_(buffBuilder.m_231175_());
            VertexBuffer.m_85931_();
            renderInfo.isFinished = true;
            this.lastRenderInfo = renderInfo;
        }
        return this.lastRenderInfo;
    }

    protected void render(Minecraft mc, LocalPlayer player, ItemStack stack, PoseStack poseStack, Matrix4f projectionMatrix, double camX, double camY, double camZ) {
        if (this.lineBuffer != null) {
            poseStack.m_85836_();
            RenderSystem.m_157427_(GameRenderer::m_172811_);
            RenderSystem.m_69478_();
            RenderSystem.m_69482_();
            RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            poseStack.m_85837_(camX, camY, camZ);
            poseStack.m_85837_((double)this.renderPos.m_123341_() - camX, (double)this.renderPos.m_123342_() - camY, (double)this.renderPos.m_123343_() - camZ);
            this.lineBuffer.m_85921_();
            this.lineBuffer.m_253207_(poseStack.m_85850_().m_252922_(), projectionMatrix, RenderSystem.m_157196_());
            VertexBuffer.m_85931_();
            RenderSystem.m_69461_();
            RenderSystem.m_69465_();
            poseStack.m_85849_();
        }
    }

    protected static Collection<BlockPos> mapPosesTo(Collection<BlockPos> poses, Vec3i renderPos) {
        ArrayList<BlockPos> newPoses = new ArrayList<BlockPos>(poses.size());
        int x = renderPos.m_123341_();
        int y = renderPos.m_123342_();
        int z = renderPos.m_123343_();
        for (BlockPos pos : poses) {
            newPoses.add(pos.m_7918_(-x, -y, -z));
        }
        return newPoses;
    }

    protected boolean shouldRender(Vec3i camPos) {
        return true;
    }

    protected void updateData(Minecraft mc, ItemStack stack) {
        Vec3 hVec;
        boolean hBlock;
        Direction hDir;
        BlockPos hPos;
        HitResult hitResult = mc.f_91077_;
        if (hitResult instanceof BlockHitResult) {
            BlockHitResult bHitResult = (BlockHitResult)hitResult;
            hPos = bHitResult.m_82425_();
            hDir = bHitResult.m_82434_();
            hBlock = bHitResult.m_6662_() == HitResult.Type.BLOCK;
        } else {
            hPos = null;
            hDir = null;
            hBlock = false;
        }
        if (this.hitPos != null && !this.hitPos.equals((Object)hPos) || hPos != null && !hPos.equals((Object)this.hitPos) || this.hitPos == null != (hPos == null) || hDir != this.hitFace || hBlock != this.hitBlock) {
            this.hitPos = hPos;
            this.hitFace = hDir;
            this.hitBlock = hBlock;
            this.needsCompiled = true;
        }
        if (hitResult instanceof BlockHitResult) {
            BlockHitResult bHitResult = (BlockHitResult)hitResult;
            hVec = bHitResult.m_82450_();
        } else {
            hVec = null;
        }
        if (this.hitVec != null && !this.hitVec.equals((Object)hVec) || hVec != null && !hVec.equals((Object)this.hitVec)) {
            this.hitVec = hVec;
            this.needsCompiled = true;
        }
    }

    protected abstract void compileInfo(Minecraft var1, ItemStack var2, BufferBuilder var3, double var4, double var6, double var8, RenderInfo var10);

    protected void close() {
        if (this.lineBuffer != null) {
            this.lineBuffer.close();
        }
        this.lineBuffer = null;
    }

    public static void needsUpdated() {
        if (instance != null) {
            BuildingToolRenderer.instance.needsCompiled = true;
        }
    }

    public static void clear() {
        shouldClear = true;
    }

    static {
        BuildingToolRenderers.init();
    }

    protected static class RenderInfo {
        boolean isFinished = false;
        Vec3i renderPos = Vec3i.f_123288_;
        boolean renderFlagA = true;

        protected RenderInfo() {
        }
    }

    protected record RenderResult(RenderInfo renderInfo, BufferBuilder buffBuilder) {
    }

    protected static abstract class ForCorners
    extends BuildingToolRenderer {
        boolean wasHoldingShift = false;
        @Nullable
        SmartBoundingBox.CornerType oldCorner = null;
        @Nullable
        protected BlockPos secondPos;
        @Nullable
        private VertexBuffer targetBuffer = null;

        protected ForCorners() {
        }

        @Override
        protected boolean shouldRender(Vec3i camPos) {
            return true;
        }

        @Override
        protected void updateData(Minecraft mc, ItemStack stack) {
            super.updateData(mc, stack);
            Optional<BlockPos> pos0 = BuildingToolItem.getPos(stack, 0);
            Optional<BlockPos> pos1 = BuildingToolItem.getPos(stack, 1);
            boolean pos0Flag = this.arePosesDifferent(pos0, this.pos);
            boolean pos1Flag = this.arePosesDifferent(pos1, this.secondPos);
            SmartBoundingBox.CornerType corner = BuildingToolItem.getSelectedCorner(stack);
            boolean isHoldingShift = mc.f_91074_.m_6144_();
            this.pos = pos0.orElse(null);
            this.secondPos = pos1.orElse(null);
            if (pos0Flag || pos1Flag || this.wasHoldingShift != isHoldingShift || this.oldCorner != corner) {
                this.needsCompiled = true;
            }
            this.wasHoldingShift = isHoldingShift;
            this.oldCorner = corner;
        }

        private boolean arePosesDifferent(Optional<BlockPos> opPos, BlockPos compareTo) {
            return opPos.isPresent() ? !opPos.get().equals((Object)compareTo) : compareTo != null;
        }

        protected abstract float[] getOutlineRGB();

        @Override
        protected void compileInfo(Minecraft mc, ItemStack stack, BufferBuilder buffBuilder, double camX, double camY, double camZ, RenderInfo renderInfo) {
            boolean hasPosA = this.pos != null;
            boolean hasPosB = this.secondPos != null;
            float selectionPointAlpha = 0.5f;
            Vec3i renderPos = this.renderPos;
            renderInfo.renderFlagA = false;
            if (hasPosA && !hasPosB) {
                renderPos = this.pos;
                IRenderBase.makeLineBox(buffBuilder, BoundingBox.m_162375_((Vec3i)Vec3i.f_123288_, (Vec3i)Vec3i.f_123288_), 0.75f, 0.0f, 0.0f, selectionPointAlpha);
            }
            if (!hasPosA && hasPosB) {
                renderPos = this.secondPos;
                IRenderBase.makeLineBox(buffBuilder, BoundingBox.m_162375_((Vec3i)Vec3i.f_123288_, (Vec3i)Vec3i.f_123288_), 0.0f, 0.0f, 0.75f, selectionPointAlpha);
            }
            if (hasPosA && hasPosB) {
                SmartBoundingBox.CornerType selectedCorner = BuildingToolItem.getSelectedCorner(stack);
                float[] rgb = this.getOutlineRGB();
                BoundingBox bb = BoundingBox.m_162375_((Vec3i)this.pos, (Vec3i)this.secondPos);
                renderPos = new Vec3i(bb.m_162395_(), bb.m_162396_(), bb.m_162398_());
                double pointWidth = 0.51;
                Vec3 pointWidthVec = new Vec3(pointWidth, pointWidth, pointWidth);
                Vec3 posA = Vec3.m_82512_((Vec3i)this.pos.m_121996_(renderPos));
                Vec3 posB = Vec3.m_82512_((Vec3i)this.secondPos.m_121996_(renderPos));
                IRenderBase.makeBox(buffBuilder, posA.m_82546_(pointWidthVec), posA.m_82549_(pointWidthVec), 0.75f, 0.0f, 0.0f, selectionPointAlpha);
                IRenderBase.makeBox(buffBuilder, posB.m_82546_(pointWidthVec), posB.m_82549_(pointWidthVec), 0.0f, 0.0f, 0.75f, selectionPointAlpha);
                IRenderBase.makeLineBox(buffBuilder, BoundingBox.m_162375_((Vec3i)Vec3i.f_123288_, (Vec3i)bb.m_71053_()), rgb[0], rgb[1], rgb[2], 0.3f);
                if (selectedCorner != null) {
                    double boxWidth = 0.505;
                    Vec3 boxWidthVec = new Vec3(boxWidth, boxWidth, boxWidth);
                    IRenderBase.makeBox(buffBuilder, Vec3.m_82512_((Vec3i)Vec3i.f_123288_).m_82546_(boxWidthVec), Vec3.m_82512_((Vec3i)bb.m_71053_()).m_82549_(boxWidthVec), rgb[0], rgb[1], rgb[2], 0.1f);
                }
                double cornerWidth = 0.3;
                Vec3 cornerWidthVec = new Vec3(cornerWidth, cornerWidth, cornerWidth);
                double range = 10.0;
                Vec3 lookVec = mc.f_91074_.m_20154_();
                Vec3 playerPos = mc.f_91074_.m_146892_();
                Vec3 rp = new Vec3((double)renderPos.m_123341_(), (double)renderPos.m_123342_(), (double)renderPos.m_123343_());
                for (SmartBoundingBox.Corner corner : SmartBoundingBox.fromCorners((Vec3i)new BlockPos(posA), (Vec3i)new BlockPos(posB)).getCorners()) {
                    Vec3i cornerPos = corner.getPoint();
                    Vec3 c = new Vec3((double)cornerPos.m_123341_(), (double)cornerPos.m_123342_(), (double)cornerPos.m_123343_());
                    AABB aabb = new AABB(c.m_82546_(cornerWidthVec).m_82549_(rp), c.m_82549_(cornerWidthVec).m_82549_(rp));
                    if (selectedCorner != corner.type && !aabb.m_82371_(playerPos, playerPos.m_82549_(lookVec.m_82542_(range, range, range))).isPresent()) continue;
                    IRenderBase.makeBox(buffBuilder, c.m_82546_(cornerWidthVec), c.m_82549_(cornerWidthVec), 0.0f, 0.7f, 0.3f, 0.5f);
                    renderInfo.renderFlagA = true;
                    break;
                }
            }
            renderInfo.renderPos = renderPos;
        }

        protected void compileTarget(Minecraft mc, ItemStack stack, BufferBuilder buffBuilder, double camX, double camY, double camZ, RenderInfo renderInfo) {
            if (currentMode == BuildingToolModes.CLONE && this.pos != null && this.secondPos != null) {
                return;
            }
            if (renderInfo.renderFlagA) {
                return;
            }
            if (this.hitPos != null) {
                boolean posA = !mc.f_91074_.m_6144_();
                float[] color = new float[]{posA ? 0.75f : 0.0f, 0.0f, posA ? 0.0f : 0.75f};
                float selectionPointAlpha = 0.3f;
                if (mc.f_91073_.m_8055_(this.hitPos).m_60795_()) {
                    double min = 0.15;
                    double max = 0.85;
                    IRenderBase.makeBox(buffBuilder, new Vec3(min, min, min), new Vec3(max, max, max), color[0], color[1], color[2], selectionPointAlpha);
                } else {
                    double min = 0.01;
                    double max = 0.99;
                    IRenderBase.makeLineBox(buffBuilder, min, min, min, max, max, max, color[0], color[1], color[2], selectionPointAlpha);
                }
            }
        }

        @Override
        protected RenderInfo compile(Minecraft mc, LocalPlayer player, ItemStack stack, double camX, double camY, double camZ) {
            RenderInfo ret = super.compile(mc, player, stack, camX, camY, camZ);
            if (this.targetBuffer != null) {
                this.targetBuffer.close();
            }
            this.targetBuffer = new VertexBuffer();
            BufferBuilder buffBuilder = Tesselator.m_85913_().m_85915_();
            buffBuilder.m_166779_(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.f_85815_);
            this.compileTarget(mc, stack, buffBuilder, camX, camY, camZ, ret);
            this.targetBuffer.m_85921_();
            this.targetBuffer.m_231221_(buffBuilder.m_231175_());
            VertexBuffer.m_85931_();
            return ret;
        }

        @Override
        protected void render(Minecraft mc, LocalPlayer player, ItemStack stack, PoseStack poseStack, Matrix4f projectionMatrix, double camX, double camY, double camZ) {
            BlockPos camPos = mc.f_91063_.m_109153_().m_90588_();
            int dist = 300;
            if (this.pos != null && this.pos.m_123314_((Vec3i)camPos, (double)dist) || this.secondPos != null && this.secondPos.m_123314_((Vec3i)camPos, (double)dist)) {
                super.render(mc, player, stack, poseStack, projectionMatrix, camX, camY, camZ);
            }
            if (this.targetBuffer != null && this.hitPos != null) {
                poseStack.m_85836_();
                RenderSystem.m_157427_(GameRenderer::m_172811_);
                RenderSystem.m_69478_();
                RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                RenderSystem.m_69482_();
                poseStack.m_252880_((float)this.hitPos.m_123341_(), (float)this.hitPos.m_123342_(), (float)this.hitPos.m_123343_());
                this.targetBuffer.m_85921_();
                this.targetBuffer.m_253207_(poseStack.m_85850_().m_252922_(), projectionMatrix, RenderSystem.m_157196_());
                VertexBuffer.m_85931_();
                RenderSystem.m_69461_();
                RenderSystem.m_69465_();
                poseStack.m_85849_();
            }
        }

        @Override
        protected void close() {
            super.close();
            if (this.targetBuffer != null) {
                this.targetBuffer.close();
            }
            this.targetBuffer = null;
        }
    }
}

