/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.client.screen.building_tool;

import com.legacy.structure_gel.core.client.ClientProxy;
import com.legacy.structure_gel.core.client.screen.building_tool.BuildingToolScreen;
import com.legacy.structure_gel.core.client.widget.PropertyEditBox;
import com.legacy.structure_gel.core.client.widget.TexturedEditBox;
import com.legacy.structure_gel.core.client.widget.TooltipImageButton;
import com.legacy.structure_gel.core.item.building_tool.ToolModeProperty;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class EditPalleteScreen
extends Screen {
    private final BuildingToolScreen parent;
    private static final int MAX_VISIBLE_AT_ONCE = 7;
    private List<PalleteEntryGroup> palleteEntryWidgets = new ArrayList<PalleteEntryGroup>();
    private TooltipImageButton addButton;
    private TooltipImageButton scrollUpButton;
    private TooltipImageButton scrollDownButton;
    private int displayIndexStart = 0;
    private int addIndex = 0;
    private int removeCooldown = 0;

    public EditPalleteScreen(BuildingToolScreen parent) {
        super((Component)Component.m_237119_());
        this.parent = parent;
    }

    protected void m_7856_() {
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2;
        List palleteList = this.parent.pallete.m_146337_() ? SimpleWeightedRandomList.m_146263_().m_146271_((Object)Blocks.f_50016_.m_49966_(), 1).m_146270_().m_146338_() : this.parent.pallete.m_146338_();
        this.palleteEntryWidgets = new ArrayList<PalleteEntryGroup>();
        for (int i = 0; i < palleteList.size(); ++i) {
            WeightedEntry.Wrapper wrapper = (WeightedEntry.Wrapper)palleteList.get(i);
            this.addPalleteEntry((BlockState)wrapper.m_146310_(), wrapper.m_142631_().m_146281_(), false);
        }
        this.addButton = (TooltipImageButton)this.m_142416_((GuiEventListener)new TooltipImageButton(centerX + 185, centerY - 11, 16, 16, 0, 112, BuildingToolScreen.WIDGETS, b -> this.addPalleteEntry(null, 1, true)));
        this.scrollUpButton = (TooltipImageButton)this.m_142416_((GuiEventListener)new TooltipImageButton(centerX + 185, centerY - 11 - 20, 16, 16, 0, 208, BuildingToolScreen.WIDGETS, b -> this.scrollUp()));
        this.scrollDownButton = (TooltipImageButton)this.m_142416_((GuiEventListener)new TooltipImageButton(centerX + 185, centerY - 11 + 20, 16, 16, 16, 208, BuildingToolScreen.WIDGETS, b -> this.scrollDown()));
        this.repositionPalleteEntries();
    }

    private void addPalleteEntry(@Nullable BlockState state, int weight, boolean reposition) {
        int texSize = 256;
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2;
        int stateEditWidth = 206;
        int index = this.addIndex++;
        TexturedEditBox stateEdit = (TexturedEditBox)this.m_7787_((GuiEventListener)new TexturedEditBox(this.f_96541_.f_91062_, centerX - 30 - stateEditWidth / 2, centerY, stateEditWidth, 24, 50, 48, texSize, texSize, BuildingToolScreen.WIDGETS, BuildingToolScreen.BLOCK_PALLETE_TEXT));
        stateEdit.m_94199_(300);
        stateEdit.m_94151_(s -> {
            int color = 0xE0E0E0;
            try {
                BlockStateParser.m_245437_((HolderLookup)BuiltInRegistries.f_256975_.m_255303_(), (String)s, (boolean)false);
            }
            catch (CommandSyntaxException e) {
                color = 14703708;
            }
            stateEdit.setTextColor(color, color);
        });
        if (state != null) {
            stateEdit.m_94144_(BlockStateParser.m_116769_((BlockState)(state.m_60713_(Blocks.f_50626_) ? Blocks.f_50016_.m_49966_() : state)));
        }
        weight = state == null ? 1 : weight;
        PropertyEditBox weightEdit = (PropertyEditBox)this.m_7787_((GuiEventListener)new PropertyEditBox<Integer>(this.f_96541_.f_91062_, centerX + 79, centerY, ToolModeProperty.WEIGHT, weight));
        TooltipImageButton removeButton = (TooltipImageButton)this.m_7787_((GuiEventListener)new TooltipImageButton(centerX - 190, centerY, 16, 16, 16, 112, BuildingToolScreen.WIDGETS, b -> this.removePalleteEntry(index)));
        PalleteEntryGroup palleteGroup = new PalleteEntryGroup(index, stateEdit, weightEdit, removeButton);
        this.palleteEntryWidgets.add(palleteGroup);
        if (reposition) {
            if (this.palleteEntryWidgets.size() > 7) {
                this.scrollDown();
            } else {
                this.repositionPalleteEntries();
            }
        }
    }

    private void removePalleteEntry(int id) {
        if (this.removeCooldown > 0) {
            return;
        }
        int positionInList = 0;
        for (int i = 0; i < this.palleteEntryWidgets.size(); ++i) {
            if (this.palleteEntryWidgets.get((int)i).id != id) continue;
            positionInList = i;
            break;
        }
        PalleteEntryGroup entry = this.palleteEntryWidgets.remove(positionInList);
        this.m_169411_((GuiEventListener)entry.stateEdit);
        this.m_169411_((GuiEventListener)entry.weightEdit);
        this.m_169411_((GuiEventListener)entry.removeButton);
        if (this.displayIndexStart > 0) {
            this.scrollUp();
        } else {
            this.repositionPalleteEntries();
        }
        this.removeCooldown = 2;
    }

    private void repositionPalleteEntries() {
        int centerY = this.f_96544_ / 2;
        int offset = 30;
        int totalVisible = Math.min(this.palleteEntryWidgets.size(), 7);
        float baseY = (float)centerY - (float)totalVisible / 2.0f * (float)offset;
        for (PalleteEntryGroup entry : this.palleteEntryWidgets) {
            entry.setVisible(false);
        }
        for (int i = this.displayIndexStart; i < this.displayIndexStart + 7 && i < this.palleteEntryWidgets.size(); ++i) {
            int pos = i - this.displayIndexStart;
            PalleteEntryGroup entry = this.palleteEntryWidgets.get(i);
            entry.setVisible(true);
            entry.move((int)((float)(offset * pos) + baseY));
        }
        if (this.palleteEntryWidgets.size() > 7) {
            this.scrollUpButton.f_93623_ = this.displayIndexStart > 0;
            this.scrollDownButton.f_93623_ = this.displayIndexStart < this.palleteEntryWidgets.size() - 7;
        } else {
            this.scrollDownButton.f_93623_ = false;
            this.scrollUpButton.f_93623_ = false;
        }
    }

    private void scrollUp() {
        if (this.displayIndexStart > 0) {
            --this.displayIndexStart;
        }
        this.repositionPalleteEntries();
    }

    private void scrollDown() {
        if (this.displayIndexStart < this.palleteEntryWidgets.size() - 7) {
            ++this.displayIndexStart;
        }
        this.repositionPalleteEntries();
    }

    public void m_86412_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.parent.renderGrayBackground(poseStack, this.f_96543_, this.f_96544_);
        for (PalleteEntryGroup entry : this.palleteEntryWidgets) {
            if (!entry.isVisible()) continue;
            entry.render(poseStack, mouseX, mouseY, partialTick);
        }
        super.m_86412_(poseStack, mouseX, mouseY, partialTick);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (delta > 0.0) {
            this.scrollUp();
        }
        if (delta < 0.0) {
            this.scrollDown();
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    public boolean m_6375_(double mouseX, double mouseY, int clickType) {
        return super.m_6375_(mouseX, mouseY, clickType);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        InputConstants.Key key = InputConstants.Type.KEYSYM.m_84895_(keyCode);
        int escape = 256;
        int tab = 258;
        int backspace = 259;
        boolean holdingShift = modifiers == 1;
        boolean pressedEnter = keyCode == 257 || keyCode == 335;
        for (PalleteEntryGroup entry : this.palleteEntryWidgets) {
            if (entry.stateEdit.m_93696_()) {
                if (escape == keyCode || pressedEnter) {
                    this.back();
                    return true;
                }
                if (tab == keyCode) {
                    this.m_5755_(!holdingShift);
                    return true;
                }
                return entry.stateEdit.m_7933_(keyCode, scanCode, modifiers);
            }
            if (!entry.weightEdit.m_93696_()) continue;
            if (escape == keyCode || pressedEnter) {
                this.back();
                return true;
            }
            if (tab == keyCode) {
                this.m_5755_(!holdingShift);
                return true;
            }
            return entry.weightEdit.m_7933_(keyCode, scanCode, modifiers);
        }
        if (escape == keyCode || this.f_96541_.f_91066_.f_92092_.isActiveAndMatches(key) || ((KeyMapping)ClientProxy.BUILDING_TOOL_KEY.get()).isActiveAndMatches(key) || pressedEnter || backspace == keyCode) {
            this.back();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    private void back() {
        SimpleWeightedRandomList.Builder statesBuilder = SimpleWeightedRandomList.m_146263_();
        for (PalleteEntryGroup entry : this.palleteEntryWidgets) {
            Optional<Pair<BlockState, Integer>> opData = entry.parse();
            if (!opData.isPresent()) continue;
            Pair<BlockState, Integer> data = opData.get();
            statesBuilder.m_146271_((Object)((BlockState)data.getFirst()), ((Integer)data.getSecond()).intValue());
        }
        this.parent.pallete = statesBuilder.m_146270_();
        BuildingToolScreen.playClickSound();
        this.f_96541_.m_91152_((Screen)this.parent);
    }

    public void m_86600_() {
        this.parent.m_86600_();
        if (this.removeCooldown > 0) {
            --this.removeCooldown;
        }
    }

    public boolean m_7043_() {
        return false;
    }

    public boolean m_5755_(boolean goForward) {
        GuiEventListener oldFocused = this.m_7222_();
        boolean ret = super.m_5755_(goForward);
        GuiEventListener newFocused = this.m_7222_();
        if (oldFocused != newFocused) {
            if (newFocused == this.addButton || newFocused == this.scrollUpButton || newFocused == this.scrollDownButton) {
                this.m_5755_(goForward);
            }
            int size = this.palleteEntryWidgets.size();
            for (int i = 0; i < size; ++i) {
                PalleteEntryGroup entry = this.palleteEntryWidgets.get(i);
                if (newFocused == entry.removeButton) {
                    if (i == size - 1) {
                        this.addPalleteEntry(null, 1, true);
                        BuildingToolScreen.playClickSound();
                    }
                    if (goForward && i + 1 == this.displayIndexStart + 7) {
                        this.scrollDown();
                    }
                    this.m_5755_(goForward);
                }
                if (oldFocused == entry.stateEdit && !goForward && i == this.displayIndexStart) {
                    PropertyEditBox<Integer> topNewFocus;
                    this.scrollUp();
                    PalleteEntryGroup topEntry = this.palleteEntryWidgets.get(Math.max(0, i - 1));
                    PropertyEditBox<Integer> propertyEditBox = topNewFocus = i == 0 ? topEntry.stateEdit : topEntry.weightEdit;
                    if (topNewFocus.m_5755_(goForward)) {
                        this.m_7522_((GuiEventListener)topNewFocus);
                    }
                }
                if (newFocused == entry.weightEdit && Integer.toString(1).equals(entry.weightEdit.m_94155_())) {
                    entry.weightEdit.m_94144_("");
                }
                if (oldFocused != entry.weightEdit || !entry.weightEdit.m_94155_().isBlank()) continue;
                entry.weightEdit.m_94144_(Integer.toString(1));
            }
        }
        return ret;
    }

    private class PalleteEntryGroup {
        final int id;
        final TexturedEditBox stateEdit;
        final PropertyEditBox<Integer> weightEdit;
        final TooltipImageButton removeButton;
        private boolean visible = true;

        private PalleteEntryGroup(int id, TexturedEditBox stateEdit, PropertyEditBox<Integer> weightEdit, TooltipImageButton removeButton) {
            this.id = id;
            this.stateEdit = stateEdit;
            this.weightEdit = weightEdit;
            this.removeButton = removeButton;
        }

        public void render(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
            this.stateEdit.m_86412_(poseStack, mouseX, mouseY, partialTick);
            this.weightEdit.m_86412_(poseStack, mouseX, mouseY, partialTick);
            this.removeButton.m_86412_(poseStack, mouseX, mouseY, partialTick);
            EditPalleteScreen screen = EditPalleteScreen.this;
            int centerX = screen.f_96543_ / 2;
            int widgetY = this.stateEdit.m_252907_();
            RenderSystem.m_157456_((int)0, (ResourceLocation)BuildingToolScreen.WIDGETS);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_69478_();
            screen.m_93228_(poseStack, centerX - 163, widgetY, 0, 160, 24, 24);
            Optional<ItemStack> stack = screen.parent.getItemForBlock(this.stateEdit.m_94155_());
            if (stack.isPresent()) {
                screen.f_96541_.m_91291_().m_115203_(stack.get(), centerX - 163 + 4, widgetY + 4);
            }
        }

        public void setVisible(boolean visible) {
            this.stateEdit.f_93624_ = visible;
            this.weightEdit.f_93624_ = visible;
            this.removeButton.f_93624_ = visible;
            this.visible = visible;
        }

        public boolean isVisible() {
            return this.visible;
        }

        public void move(int newY) {
            this.stateEdit.m_252888_(newY);
            this.weightEdit.m_252888_(newY);
            this.removeButton.m_252888_(newY + 4);
        }

        public Optional<Pair<BlockState, Integer>> parse() {
            try {
                BlockState state = BlockStateParser.m_245437_((HolderLookup)BuiltInRegistries.f_256975_.m_255303_(), (String)this.stateEdit.m_94155_(), (boolean)false).f_234748_();
                int weight = (Integer)ToolModeProperty.WEIGHT.read(this.weightEdit.m_94155_());
                return Optional.of(Pair.of((Object)state, (Object)weight));
            }
            catch (Exception exception) {
                return Optional.empty();
            }
        }
    }
}

