/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceOrTagKeyArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.phys.Vec2;

public class StructureDistanceCommand {
    private static final DynamicCommandExceptionType ERROR_STRUCTURE_INVALID = new DynamicCommandExceptionType(o -> Component.m_237110_((String)"commands.locate.structure.invalid", (Object[])new Object[]{o}));
    private static final DynamicCommandExceptionType ERROR_BIOME_INVALID = new DynamicCommandExceptionType(o -> Component.m_237110_((String)"commands.locate.biome.invalid", (Object[])new Object[]{o}));

    public static LiteralArgumentBuilder<CommandSourceStack> get() {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)Commands.m_82127_((String)"distance").requires(source -> source.m_6761_(2));
        command.then(Commands.m_82127_((String)"structure").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"structure", (ArgumentType)ResourceOrTagKeyArgument.m_247494_((ResourceKey)Registries.f_256944_)).executes(c -> StructureDistanceCommand.structure((CommandContext<CommandSourceStack>)c, (ResourceOrTagKeyArgument.Result<Structure>)ResourceOrTagKeyArgument.m_246379_((CommandContext)c, (String)"structure", (ResourceKey)Registries.f_256944_, (DynamicCommandExceptionType)ERROR_STRUCTURE_INVALID), 25))).then(Commands.m_82129_((String)"sample_size", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(c -> StructureDistanceCommand.structure((CommandContext<CommandSourceStack>)c, (ResourceOrTagKeyArgument.Result<Structure>)ResourceOrTagKeyArgument.m_246379_((CommandContext)c, (String)"structure", (ResourceKey)Registries.f_256944_, (DynamicCommandExceptionType)ERROR_STRUCTURE_INVALID), (Integer)c.getArgument("sample_size", Integer.class))))));
        command.then(Commands.m_82127_((String)"biome").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"biome", (ArgumentType)ResourceOrTagKeyArgument.m_247494_((ResourceKey)Registries.f_256952_)).executes(c -> StructureDistanceCommand.biome((CommandContext<CommandSourceStack>)c, (ResourceOrTagKeyArgument.Result<Biome>)ResourceOrTagKeyArgument.m_246379_((CommandContext)c, (String)"biome", (ResourceKey)Registries.f_256952_, (DynamicCommandExceptionType)ERROR_BIOME_INVALID), 25))).then(Commands.m_82129_((String)"sample_size", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(c -> StructureDistanceCommand.biome((CommandContext<CommandSourceStack>)c, (ResourceOrTagKeyArgument.Result<Biome>)ResourceOrTagKeyArgument.m_246379_((CommandContext)c, (String)"biome", (ResourceKey)Registries.f_256952_, (DynamicCommandExceptionType)ERROR_BIOME_INVALID), (Integer)c.getArgument("sample_size", Integer.class))))));
        command.then(Commands.m_82127_((String)"vanilla_stats").executes(c -> StructureDistanceCommand.printVanillaStats((CommandContext<CommandSourceStack>)c)));
        return command;
    }

    private static <T> Optional<? extends HolderSet.ListBacked<T>> getHolders(ResourceOrTagKeyArgument.Result<T> result, Registry<T> registry) {
        return (Optional)result.m_245276_().map(key -> registry.m_203636_(key).map(xva$0 -> HolderSet.m_205809_((Holder[])new Holder[]{xva$0})), arg_0 -> registry.m_203431_(arg_0));
    }

    private static int structure(CommandContext<CommandSourceStack> context, ResourceOrTagKeyArgument.Result<Structure> result, int sampleSize) throws CommandSyntaxException {
        return StructureDistanceCommand.distance(context, result, sampleSize, Registries.f_256944_, ERROR_STRUCTURE_INVALID, (level, pos, holderSet) -> Optional.ofNullable(level.m_7726_().m_8481_().m_223037_(level, holderSet, pos, 100, false)));
    }

    private static int biome(CommandContext<CommandSourceStack> context, ResourceOrTagKeyArgument.Result<Biome> result, int sampleSize) throws CommandSyntaxException {
        return StructureDistanceCommand.distance(context, result, sampleSize, Registries.f_256952_, ERROR_BIOME_INVALID, (level, pos, holderSet) -> Optional.ofNullable(level.m_215069_(arg_0 -> ((HolderSet)holderSet).m_203333_(arg_0), pos, 6400, 32, 64)));
    }

    private static <T> int distance(CommandContext<CommandSourceStack> context, ResourceOrTagKeyArgument.Result<T> result, int sampleSize, ResourceKey<Registry<T>> registry, DynamicCommandExceptionType error, Search<T> search) throws CommandSyntaxException {
        ServerPlayer player;
        String searchFor = result.m_245390_();
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerLevel level = source.m_81372_();
        int r = (int)((double)level.m_7654_().m_6329_() * 0.9);
        int y = (int)source.m_81371_().f_82480_;
        HolderSet holderSet = (HolderSet)StructureDistanceCommand.getHolders(result, source.m_5894_().m_175515_(registry)).orElseThrow(() -> error.create((Object)searchFor));
        if (holderSet.m_203632_() < 1) {
            source.m_81352_((Component)Component.m_237113_((String)(searchFor + " contains no values or does not exist.")));
            return 0;
        }
        RandomSource rand = level.m_213780_();
        int totalDistance = 0;
        int maxDistance = 0;
        int actuallyFound = 0;
        ArrayList<Pair> failedSearches = new ArrayList<Pair>();
        source.m_81354_((Component)Component.m_237113_((String)String.format("Started search for %s with a sample size of %d. This may take a while.", searchFor, sampleSize)), true);
        for (int i = 0; i < sampleSize; ++i) {
            BlockPos searchPos = new BlockPos(rand.m_188503_(r * 2) - r, y, rand.m_188503_(r * 2) - r);
            source.m_81354_((Component)Component.m_237113_((String)String.format("Search %d/%d at (%d, %d, %d)", i + 1, sampleSize, searchPos.m_123341_(), searchPos.m_123342_(), searchPos.m_123343_())).m_130940_(ChatFormatting.GRAY), false);
            Optional<Pair<BlockPos, Holder<T>>> pair = search.search(level, searchPos, holderSet);
            if (pair.isPresent()) {
                ++actuallyFound;
                BlockPos p = (BlockPos)pair.get().getFirst();
                int distance = (int)Math.sqrt(new Vec2((float)searchPos.m_123341_(), (float)searchPos.m_123343_()).m_165914_(new Vec2((float)p.m_123341_(), (float)p.m_123343_())));
                totalDistance += distance;
                if (distance <= maxDistance) continue;
                maxDistance = distance;
                continue;
            }
            failedSearches.add(Pair.of((Object)(i + 1), (Object)searchPos));
        }
        int averageDist = actuallyFound > 0 ? totalDistance / actuallyFound : 0;
        source.m_81354_((Component)Component.m_237113_((String)("Results for " + searchFor)).m_130940_(ChatFormatting.GREEN), false);
        source.m_81354_((Component)Component.m_237113_((String)"- Average Distance: ").m_7220_((Component)Component.m_237113_((String)("" + averageDist)).m_130940_(ChatFormatting.GRAY)), false);
        source.m_81354_((Component)Component.m_237113_((String)"- Max Distance: ").m_7220_((Component)Component.m_237113_((String)("" + maxDistance)).m_130940_(ChatFormatting.GRAY)), false);
        source.m_81354_((Component)Component.m_237113_((String)"- Found: ").m_7220_((Component)Component.m_237113_((String)(actuallyFound + "/" + sampleSize)).m_130940_(ChatFormatting.GRAY)), false);
        if (failedSearches.size() > 0) {
            source.m_81354_((Component)Component.m_237113_((String)"Failed searches").m_130940_(ChatFormatting.RED), false);
            for (Pair fail : failedSearches) {
                BlockPos pos = (BlockPos)fail.getSecond();
                source.m_81354_((Component)Component.m_237113_((String)"- Search: ").m_7220_((Component)Component.m_237113_((String)("" + fail.getFirst())).m_130940_(ChatFormatting.GRAY)).m_7220_((Component)Component.m_237113_((String)", Pos: ")).m_7220_((Component)Component.m_237113_((String)String.format("(%d, %d, %d)", pos.m_123341_(), pos.m_123342_(), pos.m_123343_())).m_130940_(ChatFormatting.GRAY)), false);
            }
        }
        if ((player = source.m_230896_()) != null) {
            player.m_6330_((SoundEvent)SoundEvents.f_12214_.get(), SoundSource.MASTER, 1.0f, 1.5f);
        }
        return averageDist;
    }

    private static int printVanillaStats(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        TreeMap<String, Integer> distances = new TreeMap<String, Integer>();
        distances.put("Village", 720);
        distances.put("Desert Pyramid", 3500);
        distances.put("Jungle Pyramid", 1937);
        distances.put("Ocean Monument", 1302);
        distances.put("Woodland Mansion", 4492);
        distances.put("Pillager Outpost", 1362);
        distances.put("Ancient City", 1521);
        distances.put("End City", 1164);
        distances.put("Nether Fortress", 418);
        distances.put("Bastion Remnant", 416);
        source.m_81354_((Component)Component.m_237113_((String)"Average distances of vanilla structures (Recorded in 1.19.2)").m_130940_(ChatFormatting.GREEN), false);
        for (Map.Entry entry : distances.entrySet()) {
            source.m_81354_((Component)Component.m_237113_((String)("- " + (String)entry.getKey() + ": ")).m_7220_((Component)Component.m_237113_((String)("" + entry.getValue())).m_130940_(ChatFormatting.GRAY)), false);
        }
        return 1;
    }

    @FunctionalInterface
    private static interface Search<T> {
        public Optional<Pair<BlockPos, Holder<T>>> search(ServerLevel var1, BlockPos var2, HolderSet<T> var3);
    }
}

