/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.events;

import com.legacy.structure_gel.api.block.GelPortalBlock;
import com.legacy.structure_gel.core.StructureGelMod;
import com.legacy.structure_gel.core.capability.entity.GelEntity;
import com.legacy.structure_gel.core.client.ClientProxy;
import com.legacy.structure_gel.core.client.renderers.BuildingToolRenderer;
import com.legacy.structure_gel.core.client.renderers.StructureBoundsRenderer;
import com.legacy.structure_gel.core.client.renderers.block_entity.DataHandlerRenderer;
import com.legacy.structure_gel.core.client.renderers.block_entity.DynamicSpawnerRenderer;
import com.legacy.structure_gel.core.client.renderers.block_entity.GelJigsawRenderer;
import com.legacy.structure_gel.core.item.building_tool.BuildingToolItem;
import com.legacy.structure_gel.core.item.building_tool.BuildingToolModes;
import com.legacy.structure_gel.core.registry.SGRegistry;
import com.legacy.structure_gel.core.util.Internal;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.properties.StructureMode;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import org.joml.Matrix4f;

@Internal
public class SGClientEvents {

    @Mod.EventBusSubscriber(modid="structure_gel", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
    protected static class ForgeBus {
        protected ForgeBus() {
        }

        @SubscribeEvent
        protected static void onPlaySound(PlaySoundEvent event) {
            SoundInstance originalSound = event.getOriginalSound();
            if (originalSound != null) {
                ResourceLocation name = originalSound.m_7904_();
                GelPortalBlock portal = GelEntity.getPortalClient();
                if (portal != null && name != null) {
                    SoundInstance newSound = null;
                    if (name.equals((Object)SoundEvents.f_12287_.m_11660_())) {
                        newSound = portal.getTravelSound();
                    } else if (name.equals((Object)SoundEvents.f_12288_.m_11660_())) {
                        newSound = portal.getTriggerSound();
                    }
                    if (newSound != null) {
                        event.setSound(newSound);
                    }
                }
            }
        }

        @SubscribeEvent
        protected static void clientPlayerTick(TickEvent.PlayerTickEvent event) {
            if (event.phase == TickEvent.Phase.END && event.side == LogicalSide.CLIENT) {
                GelEntity.clientTick();
            }
        }

        @SubscribeEvent
        protected static void onRenderLevel(RenderLevelStageEvent event) {
            if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
                Minecraft mc = Minecraft.m_91087_();
                PoseStack poseStack = event.getPoseStack();
                Matrix4f matrix = event.getProjectionMatrix();
                Vec3 cam = event.getCamera().m_90583_();
                double camX = cam.f_82479_;
                double camY = cam.f_82480_;
                double camZ = cam.f_82481_;
                StructureBoundsRenderer.render(mc, poseStack, matrix, camX, camY, camZ);
                BuildingToolRenderer.render(mc, poseStack, matrix, camX, camY, camZ);
            }
        }

        @SubscribeEvent
        protected static void onLogin(PlayerEvent.PlayerLoggedInEvent event) {
            StructureGelMod.proxy.setViewBounds(false);
            StructureGelMod.proxy.clearToolRenderCache();
        }
    }

    @Mod.EventBusSubscriber(modid="structure_gel", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    protected static class ModBus {
        protected ModBus() {
        }

        @SubscribeEvent
        protected static void clientInit(FMLClientSetupEvent event) {
            event.enqueueWork(() -> {
                ItemProperties.register((Item)Items.f_42352_, (ResourceLocation)StructureGelMod.locate("mode"), (stack, level, entity, layer) -> {
                    CompoundTag blockEntityTag;
                    CompoundTag tag = stack.m_41783_();
                    if (tag != null && tag.m_128425_("BlockEntityTag", 10) && (blockEntityTag = tag.m_128469_("BlockEntityTag")).m_128425_("mode", 8)) {
                        return StructureMode.valueOf((String)blockEntityTag.m_128461_("mode")).ordinal();
                    }
                    return -1.0f;
                });
                ItemProperties.register((Item)SGRegistry.Items.BUILDING_TOOL.get(), (ResourceLocation)StructureGelMod.locate("mode"), (stack, level, entity, layer) -> BuildingToolItem.getMode(stack).modelIndex());
            });
            BuildingToolModes.init();
        }

        @SubscribeEvent
        protected static void registerKeyMappings(RegisterKeyMappingsEvent event) {
            event.register((KeyMapping)ClientProxy.UNDO_KEY.get());
            event.register((KeyMapping)ClientProxy.REDO_KEY.get());
            event.register((KeyMapping)ClientProxy.BUILDING_TOOL_KEY.get());
        }

        @SubscribeEvent
        protected static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
            event.registerBlockEntityRenderer(BlockEntityType.f_58910_, GelJigsawRenderer::new);
            event.registerBlockEntityRenderer(SGRegistry.BlockEntities.DATA_HANDLER.get(), DataHandlerRenderer::new);
            event.registerBlockEntityRenderer(SGRegistry.BlockEntities.DYNAMIC_SPAWNER.get(), DynamicSpawnerRenderer::new);
        }
    }
}

