/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.item.building_tool;

import com.legacy.structure_gel.core.SGConfig;
import com.legacy.structure_gel.core.StructureGelMod;
import com.legacy.structure_gel.core.item.building_tool.BuildingToolItem;
import com.legacy.structure_gel.core.item.building_tool.BuildingToolMode;
import com.legacy.structure_gel.core.registry.SGRegistry;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Clearable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLEnvironment;

public class ActionHistory {
    private static final Map<String, ActionHistory> PLAYER_HISTORY = new HashMap<String, ActionHistory>();
    private static final long MAX_LIFE = TimeUnit.DAYS.toMillis(1L);
    private static final ActionHistory EMPTY = new ActionHistory(){

        @Override
        public void add(Level level, ActionBuilder action) {
        }

        @Override
        public boolean undo(ServerPlayer player) {
            return false;
        }

        @Override
        public boolean redo(ServerPlayer player) {
            return false;
        }
    };
    private final LinkedList<Action> actions = new LinkedList();
    private int lastActionIndex = 0;
    private long lastModified = System.currentTimeMillis();

    private ActionHistory() {
    }

    public static ActionHistory getHistory(String playerName) {
        return PLAYER_HISTORY.getOrDefault(playerName, EMPTY);
    }

    public static ActionHistory getOrCreateHistory(Player player) {
        if (!player.f_19853_.f_46443_) {
            return PLAYER_HISTORY.computeIfAbsent(player.m_36316_().getName(), name -> new ActionHistory());
        }
        return EMPTY;
    }

    public static Set<String> getHistoryOwners() {
        return PLAYER_HISTORY.keySet();
    }

    public void add(Level level, ActionBuilder action) {
        this.setModified();
        while (this.lastActionIndex > 0) {
            this.actions.removeFirst();
            --this.lastActionIndex;
        }
        this.actions.addFirst(action.build((ResourceKey<Level>)level.m_46472_()));
        while (this.actions.size() > SGConfig.COMMON.getBuildingToolMaxUndos()) {
            this.actions.removeLast();
        }
    }

    public boolean undo(ServerPlayer player) {
        if (this.lastActionIndex < this.actions.size()) {
            this.setModified();
            if (this.actions.get(this.lastActionIndex).undo(player, player.m_9236_())) {
                ++this.lastActionIndex;
            }
            return true;
        }
        return false;
    }

    public boolean redo(ServerPlayer player) {
        if (this.lastActionIndex > 0) {
            this.setModified();
            if (this.actions.get(this.lastActionIndex - 1).redo(player, player.m_9236_())) {
                --this.lastActionIndex;
            }
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this == EMPTY || this.actions.isEmpty();
    }

    private void setModified() {
        this.lastModified = System.currentTimeMillis();
    }

    public static void clearHistory() {
        if (FMLEnvironment.dist == Dist.CLIENT) {
            PLAYER_HISTORY.clear();
        } else {
            long time = System.currentTimeMillis();
            for (String name : PLAYER_HISTORY.keySet()) {
                ActionHistory history = PLAYER_HISTORY.get(name);
                if (history == null || time - history.lastModified <= MAX_LIFE) continue;
                PLAYER_HISTORY.remove(name);
                StructureGelMod.LOGGER.log("Cleared building tool action history for " + name, new Object[0]);
            }
        }
    }

    public static ActionBuilder newAction() {
        return new ActionBuilder();
    }

    public static class ActionBuilder {
        private final List<Change> changes = new LinkedList<Change>();

        private ActionBuilder() {
        }

        public ActionBuilder changeBlock(BlockPos pos, BlockState oldState, @Nullable CompoundTag oldBlockEntity, BlockState newState, @Nullable CompoundTag newBlockEntity) {
            this.changes.add(new BlockChange(pos, oldState, oldBlockEntity, newState, newBlockEntity));
            return this;
        }

        public ActionBuilder changeSelection(BuildingToolMode mode, int posIndex, BlockPos oldPos, BlockPos newPos) {
            this.changes.add(new SelectionChange(mode, posIndex, oldPos, newPos));
            return this;
        }

        private Action build(ResourceKey<Level> levelKey) {
            return new Action(levelKey, (Change[])this.changes.toArray(Change[]::new));
        }
    }

    private record Action(ResourceKey<Level> levelKey, Change[] changes) {
        private static final String UNDO_KEY = "info.structure_gel.building_tool.message.undo";
        private static final String REDO_KEY = "info.structure_gel.building_tool.message.redo";
        private static final String WRONG_DIMENSION = "info.structure_gel.building_tool.message.wrong_dimension";

        public boolean undo(ServerPlayer player, ServerLevel level) {
            if (level.m_46472_().equals(this.levelKey)) {
                int totalChanges = this.changes.length;
                int changes = 0;
                int lastPercent = 0;
                for (int i = this.changes.length - 1; i > -1; --i) {
                    this.changes[i].undo(player, level);
                    lastPercent = this.sendMessage(player, UNDO_KEY, lastPercent, ++changes, totalChanges);
                }
                return true;
            }
            player.m_5661_((Component)Component.m_237110_((String)WRONG_DIMENSION, (Object[])new Object[]{this.levelKey.m_135782_()}), true);
            return false;
        }

        public boolean redo(ServerPlayer player, ServerLevel level) {
            if (level.m_46472_().equals(this.levelKey)) {
                int totalChanges = this.changes.length;
                int changes = 0;
                int lastPercent = 0;
                for (Change change : this.changes) {
                    change.redo(player, level);
                    lastPercent = this.sendMessage(player, REDO_KEY, lastPercent, ++changes, totalChanges);
                }
                return true;
            }
            player.m_5661_((Component)Component.m_237110_((String)WRONG_DIMENSION, (Object[])new Object[]{this.levelKey.m_135782_()}), true);
            return false;
        }

        private int sendMessage(ServerPlayer player, String key, int lastPercent, int changes, int totalChanges) {
            int percent = Math.round((float)changes / (float)totalChanges * 100.0f);
            if (percent - lastPercent >= 1 || percent == 100) {
                player.m_5661_((Component)Component.m_237110_((String)key, (Object[])new Object[]{percent}), true);
            }
            return percent;
        }
    }

    private record SelectionChange(BuildingToolMode mode, int posIndex, BlockPos oldPos, BlockPos newPos) implements Change
    {
        @Override
        public void undo(ServerPlayer player, ServerLevel level) {
            this.apply(player, this.oldPos);
        }

        @Override
        public void redo(ServerPlayer player, ServerLevel level) {
            this.apply(player, this.newPos);
        }

        private void apply(ServerPlayer player, BlockPos pos) {
            ItemStack buildingTool;
            ItemStack mainItem = player.m_21205_();
            ItemStack offItem = player.m_21206_();
            Object object = mainItem.m_150930_((Item)SGRegistry.Items.BUILDING_TOOL.get()) ? mainItem : (buildingTool = offItem.m_150930_((Item)SGRegistry.Items.BUILDING_TOOL.get()) ? offItem : null);
            if (buildingTool != null && BuildingToolItem.getMode(buildingTool) == this.mode) {
                BuildingToolItem.setPos(buildingTool, this.posIndex, (Vec3i)pos);
            }
        }
    }

    private record BlockChange(BlockPos pos, BlockState oldState, @Nullable CompoundTag oldBlockEntity, BlockState newState, @Nullable CompoundTag newBlockEntity) implements Change
    {
        @Override
        public void undo(ServerPlayer player, ServerLevel level) {
            this.apply(level, this.oldState, this.oldBlockEntity);
        }

        @Override
        public void redo(ServerPlayer player, ServerLevel level) {
            this.apply(level, this.newState, this.newBlockEntity);
        }

        private void apply(ServerLevel level, BlockState state, @Nullable CompoundTag blockEntityTag) {
            BlockPos pos = this.pos;
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity != null) {
                Clearable.m_18908_((Object)blockEntity);
                level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 2);
            }
            int flags = 3;
            if (state.m_61138_((Property)BlockStateProperties.f_61401_) || state.m_61138_((Property)BlockStateProperties.f_61391_)) {
                flags += 16;
            }
            level.m_7731_(pos, state, flags);
            if (blockEntityTag != null) {
                level.m_7702_(pos).m_142466_(blockEntityTag);
            }
        }
    }

    private static interface Change {
        public void undo(ServerPlayer var1, ServerLevel var2);

        public void redo(ServerPlayer var1, ServerLevel var2);
    }
}

