/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.item.building_tool;

import com.legacy.structure_gel.api.registry.SGSimpleRegistry;
import com.legacy.structure_gel.api.structure.base.IModifyState;
import com.legacy.structure_gel.core.StructureGelMod;
import com.legacy.structure_gel.core.item.building_tool.ActionHistory;
import com.legacy.structure_gel.core.item.building_tool.BuildingToolItem;
import com.legacy.structure_gel.core.item.building_tool.BuildingToolMode;
import com.legacy.structure_gel.core.item.building_tool.CapturedBlocks;
import com.legacy.structure_gel.core.item.building_tool.ToolModeProperty;
import com.legacy.structure_gel.core.util.SGText;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class BuildingToolModes {
    public static final SGSimpleRegistry<ResourceLocation, BuildingToolMode> REGISTRY = new SGSimpleRegistry(StructureGelMod.locate("modes"), () -> NONE, null);
    private static final String MESSAGE_PRE = "info.structure_gel.building_tool.message.";
    protected static final String SET_POS_KEY = "info.structure_gel.building_tool.message.set_pos";
    protected static final String CLEAR_POSES_KEY = "info.structure_gel.building_tool.message.clear_poses";
    protected static final String MISSING_POS_KEY = "info.structure_gel.building_tool.message.missing_pos";
    protected static final String POS_UNLOADED_KEY = "info.structure_gel.building_tool.message.pos_unloaded";
    protected static final String SELECT_STATE_KEY = "info.structure_gel.building_tool.message.select_state";
    protected static final String SELECT_PALLETE_KEY = "info.structure_gel.building_tool.message.select_pallete";
    protected static final String MISSING_STATE_KEY = "info.structure_gel.building_tool.message.missing_state";
    public static final String SET_REACH_KEY = "info.structure_gel.building_tool.message.set_reach";
    protected static final String PLACE_BLOCKS_KEY = "info.structure_gel.building_tool.message.place_blocks";
    protected static final String REPLACE_BLOCKS_WITH_KEY = "info.structure_gel.building_tool.message.replace_blocks_with";
    protected static final String REPLACE_BLOCKS_KEY = "info.structure_gel.building_tool.message.replace_blocks";
    protected static final String CLONE_BLOCKS_KEY = "info.structure_gel.building_tool.message.clone_blocks";
    protected static final String FLOOD_BLOCKS_KEY = "info.structure_gel.building_tool.message.flood_blocks";
    protected static final String MOVE_BLOCKS_KEY = "info.structure_gel.building_tool.message.move_blocks";
    protected static final String GRABBED_CORNER_KEY = "info.structure_gel.building_tool.message.grabbed_corner";
    protected static final String PLACED_CORNER_KEY = "info.structure_gel.building_tool.message.placed_corner";
    protected static final String GRABBED_BOUNDS_KEY = "info.structure_gel.building_tool.message.grabbed_bounds";
    protected static final String PLACED_BOUNDS_KEY = "info.structure_gel.building_tool.message.placed_bounds";
    protected static final String SELECT_CORNERS = "item.structure_gel.building_tool.mode.select_corners";
    protected static final String SELECT_POSITIONS = "item.structure_gel.building_tool.mode.select_positions";
    protected static final String LENGTH_KEY = "info.structure_gel.building_tool.message.length";
    public static final BuildingToolMode NONE = BuildingToolModes.register(new BuildingToolMode("none", 0){

        @Override
        public void onRightClickBlock(Level level, Player player, BlockPos clickedPos, ItemStack stack, Direction clickedFace) {
        }

        @Override
        public boolean hasBlockPalette() {
            return false;
        }

        @Override
        public Object[] getDescArgs() {
            return new Object[0];
        }
    });
    public static final BuildingToolMode REPLACE = BuildingToolModes.register(new BuildingToolMode("replace", 1){

        @Override
        public void onLeftClick(Level level, Player player, BlockPos clickedPos, ItemStack stack, Direction clickedFace) {
            if (level.f_46443_) {
                return;
            }
            double integrity = BuildingToolItem.getProperty(stack, ToolModeProperty.INTEGRITY);
            int radius = BuildingToolItem.getProperty(stack, ToolModeProperty.MEDIUM_RADIUS);
            Set<BlockPos> poses = 2.getReplacePositions(level, clickedPos, radius);
            if (poses.isEmpty()) {
                return;
            }
            RandomSource rand = level.f_46441_;
            ActionHistory.ActionBuilder action = ActionHistory.newAction();
            WeightedRandomList<WeightedEntry.Wrapper<BlockState>> pallete = BuildingToolItem.getPallete(stack);
            for (BlockPos pos : poses) {
                Optional opState;
                if (!((double)rand.m_188501_() < integrity) || !(opState = pallete.m_216829_(rand)).isPresent()) continue;
                this.setBlock(level, pos, (BlockState)((WeightedEntry.Wrapper)opState.get()).m_146310_(), action);
            }
            ActionHistory.getOrCreateHistory(player).add(level, action);
            BlockState messageState = pallete.m_146338_().size() > 0 ? (BlockState)((WeightedEntry.Wrapper)pallete.m_146338_().get(0)).m_146310_() : Blocks.f_50069_.m_49966_();
            BuildingToolMode.sendMessage(player, pallete.m_146338_().size() == 1 ? BuildingToolModes.REPLACE_BLOCKS_WITH_KEY : BuildingToolModes.REPLACE_BLOCKS_KEY, poses.size(), pallete.m_146338_().size() == 1 ? messageState.m_60734_().m_49954_().getString() : "");
            if (!poses.isEmpty()) {
                BuildingToolMode.playSound(player, messageState);
            }
        }

        @Override
        public Object[] getDescArgs() {
            Options options = Minecraft.m_91087_().f_91066_;
            String middleClick = SGText.keybindString(options.f_92097_);
            String leftClick = SGText.keybindString(options.f_92096_);
            return new Object[]{middleClick, leftClick};
        }

        @Override
        public void addProperties(List<ToolModeProperty<?>> properties) {
            super.addProperties(properties);
            properties.add(ToolModeProperty.INTEGRITY);
            properties.add(ToolModeProperty.MEDIUM_RADIUS);
        }

        @Override
        public boolean hasBlockPalette() {
            return true;
        }
    });
    public static final BuildingToolMode FILL = BuildingToolModes.register(new BuildingToolMode.ForCorners("fill", 2, false){

        @Override
        protected void performAction(Level level, Player player, BlockPos clickedPos, ItemStack stack, BlockPos cornerA, BlockPos cornerB) {
            if (level.f_46443_) {
                return;
            }
            WeightedRandomList<WeightedEntry.Wrapper<BlockState>> pallete = BuildingToolItem.getPallete(stack);
            if (!pallete.m_146337_()) {
                boolean retainState = BuildingToolItem.getProperty(stack, ToolModeProperty.RETAIN_STATE).value();
                double integrity = BuildingToolItem.getProperty(stack, ToolModeProperty.INTEGRITY);
                ToolModeProperty.FillMode fillMode = BuildingToolItem.getProperty(stack, ToolModeProperty.FILL_MODE);
                ToolModeProperty.Replace replace = BuildingToolItem.getProperty(stack, ToolModeProperty.REPLACE);
                BlockState clickedState = level.m_8055_(clickedPos);
                ActionHistory.ActionBuilder action = ActionHistory.newAction();
                RandomSource rand = level.f_46441_;
                BlockPos minCorner = new BlockPos(Math.min(cornerA.m_123341_(), cornerB.m_123341_()), Math.min(cornerA.m_123342_(), cornerB.m_123342_()), Math.min(cornerA.m_123343_(), cornerB.m_123343_()));
                BlockPos maxCorner = new BlockPos(Math.max(cornerA.m_123341_(), cornerB.m_123341_()), Math.max(cornerA.m_123342_(), cornerB.m_123342_()), Math.max(cornerA.m_123343_(), cornerB.m_123343_()));
                int total = this.forPosesWithin((Vec3i)minCorner, (Vec3i)maxCorner, pos -> {
                    Optional opState;
                    if ((double)rand.m_188501_() < integrity && (opState = pallete.m_216829_(level.f_46441_)).isPresent()) {
                        BlockState state = (BlockState)((WeightedEntry.Wrapper)opState.get()).m_146310_();
                        int x = pos.m_123341_();
                        int y = pos.m_123342_();
                        int z = pos.m_123343_();
                        int edges = 0;
                        if (x == minCorner.m_123341_() || x == maxCorner.m_123341_()) {
                            ++edges;
                        }
                        if (y == minCorner.m_123342_() || y == maxCorner.m_123342_()) {
                            ++edges;
                        }
                        if (z == minCorner.m_123343_() || z == maxCorner.m_123343_()) {
                            ++edges;
                        }
                        if (fillMode == ToolModeProperty.FillMode.HOLLOW && edges < 1 || fillMode == ToolModeProperty.FillMode.FRAME && edges < 2) {
                            return false;
                        }
                        if (replace.shouldReplace(level, clickedState, (BlockPos)pos)) {
                            BlockState toPlace = retainState ? state : state.m_60734_().m_5573_(new BlockPlaceContext(player, InteractionHand.MAIN_HAND, state.m_60734_().m_5456_().m_7968_(), new BlockHitResult(Vec3.f_82478_, Direction.UP, pos, true)));
                            return this.setBlock(level, (BlockPos)pos, (BlockState oldState) -> replace == ToolModeProperty.Replace.CLICKED_BLOCK ? IModifyState.mergeStates(toPlace, oldState) : toPlace, action);
                        }
                    }
                    return false;
                });
                BlockState messageState = pallete.m_146338_().size() > 0 ? (BlockState)((WeightedEntry.Wrapper)pallete.m_146338_().get(0)).m_146310_() : Blocks.f_50069_.m_49966_();
                ActionHistory.getOrCreateHistory(player).add(level, action);
                BuildingToolMode.sendMessage(player, replace == ToolModeProperty.Replace.ALL ? BuildingToolModes.PLACE_BLOCKS_KEY : (pallete.m_146338_().size() == 1 ? BuildingToolModes.REPLACE_BLOCKS_WITH_KEY : BuildingToolModes.REPLACE_BLOCKS_KEY), total, pallete.m_146338_().size() == 1 ? messageState.m_60734_().m_49954_().getString() : "");
                if (total > 0) {
                    BuildingToolMode.playSound(player, messageState);
                }
            } else {
                BuildingToolMode.sendMessage(player, BuildingToolModes.MISSING_STATE_KEY, Style.f_131099_.m_131140_(ChatFormatting.RED), new Object[0]);
            }
        }

        @Override
        public Object[] getDescArgs() {
            Options options = Minecraft.m_91087_().f_91066_;
            String shift = SGText.keybindString(options.f_92090_);
            String middleClick = SGText.keybindString(options.f_92097_);
            String rightClick = SGText.keybindString(options.f_92095_);
            String leftClick = SGText.keybindString(options.f_92096_);
            return new Object[]{middleClick, Component.m_237110_((String)BuildingToolModes.SELECT_CORNERS, (Object[])new Object[]{rightClick, shift, rightClick, rightClick, shift}), leftClick};
        }

        @Override
        public void addProperties(List<ToolModeProperty<?>> properties) {
            super.addProperties(properties);
            properties.add(ToolModeProperty.INTEGRITY);
            properties.add(ToolModeProperty.FILL_MODE);
            properties.add(ToolModeProperty.RETAIN_STATE);
            properties.add(ToolModeProperty.REPLACE);
        }

        @Override
        public boolean hasBlockPalette() {
            return true;
        }
    });
    public static final BuildingToolMode CLONE = BuildingToolModes.register(new BuildingToolMode.ForCorners("clone", 3, false){

        @Override
        protected void performAction(Level level, Player player, BlockPos clickedPos, ItemStack stack, BlockPos cornerA, BlockPos cornerB) {
            if (level.f_46443_) {
                return;
            }
            double integrity = BuildingToolItem.getProperty(stack, ToolModeProperty.INTEGRITY);
            ToolModeProperty.SGRotation rotation = BuildingToolItem.getProperty(stack, ToolModeProperty.ROTATION);
            ToolModeProperty.SGMirror mirror = BuildingToolItem.getProperty(stack, ToolModeProperty.MIRROR);
            boolean cut = BuildingToolItem.getProperty(stack, ToolModeProperty.CUT_FALSE).value();
            ToolModeProperty.Replace replace = BuildingToolItem.getProperty(stack, ToolModeProperty.REPLACE_ALL_AIR);
            RandomSource rand = level.m_213780_();
            CapturedBlocks captured = new CapturedBlocks(level, cornerA, cornerB, mirror.toVanilla(rand), rotation.toVanilla(rand));
            ActionHistory.ActionBuilder action = ActionHistory.newAction();
            if (cut) {
                BlockState air = Blocks.f_50016_.m_49966_();
                this.forPosesWithin((Vec3i)cornerA, (Vec3i)cornerB, pos -> this.setBlock(level, (BlockPos)pos, air, action));
                this.clearPoses(stack, player);
            }
            BoundingBox destBB = 4.getCloneDestBounds(captured, clickedPos, level.m_8055_(clickedPos), player.m_20182_(), player.m_6144_());
            BlockPos startPos = new BlockPos(destBB.m_162395_(), destBB.m_162396_(), destBB.m_162398_());
            for (CapturedBlocks.BlockInfo info : captured.getBlockInfos()) {
                if (!((double)rand.m_188501_() < integrity)) continue;
                BlockPos placePos = startPos.m_121955_((Vec3i)info.pos());
                BlockState placeState = info.state();
                if (!replace.shouldReplace(level, placeState, placePos)) continue;
                this.setBlock(level, placePos, info.state(), info.blockEntityTag(), action);
            }
            ActionHistory.getOrCreateHistory(player).add(level, action);
            BuildingToolMode.sendMessage(player, BuildingToolModes.CLONE_BLOCKS_KEY, new Object[0]);
            BuildingToolMode.playSound(player, SoundEvents.f_12200_);
        }

        @Override
        public Object[] getDescArgs() {
            Options options = Minecraft.m_91087_().f_91066_;
            String shift = SGText.keybindString(options.f_92090_);
            String rightClick = SGText.keybindString(options.f_92095_);
            String leftClick = SGText.keybindString(options.f_92096_);
            return new Object[]{Component.m_237110_((String)BuildingToolModes.SELECT_CORNERS, (Object[])new Object[]{rightClick, shift, rightClick, rightClick, shift}), leftClick};
        }

        @Override
        public void addProperties(List<ToolModeProperty<?>> properties) {
            super.addProperties(properties);
            properties.add(ToolModeProperty.INTEGRITY);
            properties.add(ToolModeProperty.ROTATION);
            properties.add(ToolModeProperty.MIRROR);
            properties.add(ToolModeProperty.CUT_FALSE);
            properties.add(ToolModeProperty.REPLACE_ALL_AIR);
        }

        @Override
        public boolean hasBlockPalette() {
            return false;
        }
    });
    public static final BuildingToolMode FLOOD = BuildingToolModes.register(new BuildingToolMode("flood", 4){

        @Override
        public void onLeftClick(Level level, Player player, BlockPos clickedPos, ItemStack stack, Direction clickedFace) {
            if (level.f_46443_) {
                return;
            }
            WeightedRandomList<WeightedEntry.Wrapper<BlockState>> pallete = BuildingToolItem.getPallete(stack);
            if (!pallete.m_146337_()) {
                boolean extendDown = BuildingToolItem.getProperty(stack, ToolModeProperty.EXTEND_DOWN).value();
                ToolModeProperty.Replace replace = BuildingToolItem.getProperty(stack, ToolModeProperty.REPLACE_AIR_LIQUID);
                Set<BlockPos> poses = 5.getFloodPositions(level, clickedPos, clickedFace, replace);
                if (poses.isEmpty()) {
                    return;
                }
                ActionHistory.ActionBuilder action = ActionHistory.newAction();
                int dist = extendDown ? 100 : 1;
                BlockState air = Blocks.f_50016_.m_49966_();
                for (BlockPos pos : poses) {
                    BlockPos.MutableBlockPos mutPos = pos.m_122032_();
                    while (replace.shouldReplace(level, air, (BlockPos)mutPos) && pos.m_123342_() - mutPos.m_123342_() < dist) {
                        Optional opState = pallete.m_216829_(level.f_46441_);
                        if (opState.isPresent()) {
                            this.setBlock(level, mutPos.m_7949_(), (BlockState)((WeightedEntry.Wrapper)opState.get()).m_146310_(), action);
                        }
                        mutPos.m_122173_(Direction.DOWN);
                    }
                }
                ActionHistory.getOrCreateHistory(player).add(level, action);
                BlockState messageState = pallete.m_216829_(level.f_46441_).map(WeightedEntry.Wrapper::m_146310_).orElse(Blocks.f_50069_.m_49966_());
                BuildingToolMode.sendMessage(player, BuildingToolModes.FLOOD_BLOCKS_KEY, poses.size());
                if (!poses.isEmpty()) {
                    BuildingToolMode.playSound(player, messageState);
                }
            } else {
                BuildingToolMode.sendMessage(player, BuildingToolModes.MISSING_STATE_KEY, Style.f_131099_.m_131140_(ChatFormatting.RED), new Object[0]);
            }
        }

        @Override
        public Object[] getDescArgs() {
            Options options = Minecraft.m_91087_().f_91066_;
            String middleClick = SGText.keybindString(options.f_92097_);
            String leftClick = SGText.keybindString(options.f_92096_);
            String rightClick = SGText.keybindString(options.f_92095_);
            return new Object[]{middleClick, leftClick, rightClick};
        }

        @Override
        public void addProperties(List<ToolModeProperty<?>> properties) {
            super.addProperties(properties);
            properties.add(ToolModeProperty.EXTEND_DOWN);
            properties.add(ToolModeProperty.REPLACE_AIR_LIQUID);
        }

        @Override
        public boolean hasBlockPalette() {
            return true;
        }
    });
    public static final BuildingToolMode EXTEND = BuildingToolModes.register(new BuildingToolMode("extend", 5){

        @Override
        public void onLeftClick(Level level, Player player, BlockPos clickedPos, ItemStack stack, Direction clickedFace) {
            if (level.f_46443_) {
                return;
            }
            Set<BlockPos> poses = 6.getExtendPositions(level, clickedPos, clickedFace);
            if (poses.isEmpty()) {
                return;
            }
            ActionHistory.ActionBuilder action = ActionHistory.newAction();
            Direction originDir = clickedFace.m_122424_();
            for (BlockPos pos : poses) {
                BlockPos fromPos = pos.m_121945_(originDir);
                BlockEntity blockE = level.m_7702_(fromPos);
                CompoundTag blockEntityNbt = blockE != null ? blockE.m_187482_() : null;
                this.setBlock(level, pos, level.m_8055_(fromPos), blockEntityNbt, action);
            }
            ActionHistory.getOrCreateHistory(player).add(level, action);
            BuildingToolMode.sendMessage(player, BuildingToolModes.PLACE_BLOCKS_KEY, poses.size(), level.m_8055_(clickedPos).m_60734_().m_49954_().getString());
            if (!poses.isEmpty()) {
                BuildingToolMode.playSound(player, level.m_8055_(clickedPos));
            }
        }

        @Override
        public Object[] getDescArgs() {
            Options options = Minecraft.m_91087_().f_91066_;
            String leftClick = SGText.keybindString(options.f_92096_);
            return new Object[]{leftClick};
        }

        @Override
        public boolean hasBlockPalette() {
            return false;
        }
    });
    public static final BuildingToolMode MOVE = BuildingToolModes.register(new BuildingToolMode.ForCorners("move", 6, false){

        @Override
        protected void performAction(Level level, Player player, BlockPos clickedPos, ItemStack stack, BlockPos cornerA, BlockPos cornerB) {
            if (level.f_46443_) {
                return;
            }
            int dist = BuildingToolItem.getProperty(stack, ToolModeProperty.MOVE_DISTANCE);
            boolean cut = BuildingToolItem.getProperty(stack, ToolModeProperty.CUT_TRUE).value();
            ToolModeProperty.Replace replace = BuildingToolItem.getProperty(stack, ToolModeProperty.REPLACE_ALL_AIR);
            Direction facing = Direction.m_122382_((Entity)player)[0];
            if (player.m_6144_()) {
                facing = facing.m_122424_();
            }
            CapturedBlocks captured = new CapturedBlocks(level, cornerA, cornerB);
            ActionHistory.ActionBuilder action = ActionHistory.newAction();
            BlockState air = Blocks.f_50016_.m_49966_();
            if (cut) {
                this.forPosesWithin((Vec3i)cornerA, (Vec3i)cornerB, pos -> this.setBlock(level, (BlockPos)pos, air, action));
            }
            int total = 0;
            BlockPos placePos = captured.getWorldPos();
            for (CapturedBlocks.BlockInfo info : captured.getBlockInfos()) {
                BlockPos placeAt = placePos.m_121955_((Vec3i)info.pos()).m_5484_(facing, dist);
                if (!replace.shouldReplace(level, air, placeAt) || !this.setBlock(level, placeAt, info.state(), info.blockEntityTag(), action)) continue;
                ++total;
            }
            action.changeSelection(this, 0, cornerA, cornerA.m_5484_(facing, dist));
            BuildingToolItem.setPos(stack, 0, (Vec3i)cornerA.m_5484_(facing, dist));
            action.changeSelection(this, 1, cornerB, cornerB.m_5484_(facing, dist));
            BuildingToolItem.setPos(stack, 1, (Vec3i)cornerB.m_5484_(facing, dist));
            ActionHistory.getOrCreateHistory(player).add(level, action);
            BuildingToolMode.sendMessage(player, BuildingToolModes.MOVE_BLOCKS_KEY, total, facing.m_7912_());
            BuildingToolMode.playSound(player, SoundEvents.f_12312_);
        }

        @Override
        public Object[] getDescArgs() {
            Options options = Minecraft.m_91087_().f_91066_;
            String shift = SGText.keybindString(options.f_92090_);
            String rightClick = SGText.keybindString(options.f_92095_);
            String leftClick = SGText.keybindString(options.f_92096_);
            return new Object[]{Component.m_237110_((String)BuildingToolModes.SELECT_CORNERS, (Object[])new Object[]{rightClick, shift, rightClick, rightClick, shift}), leftClick};
        }

        @Override
        public void addProperties(List<ToolModeProperty<?>> properties) {
            super.addProperties(properties);
            properties.add(ToolModeProperty.MOVE_DISTANCE);
            properties.add(ToolModeProperty.CUT_TRUE);
            properties.add(ToolModeProperty.REPLACE_ALL_AIR);
        }

        @Override
        public boolean hasBlockPalette() {
            return false;
        }
    });
    public static final BuildingToolMode LINE = BuildingToolModes.register(new BuildingToolMode.ForCorners("line", 7, false){

        @Override
        public boolean hasSelectionBox() {
            return false;
        }

        @Override
        protected void performAction(Level level, Player player, BlockPos clickedPos, ItemStack stack, BlockPos cornerA, BlockPos cornerB) {
            if (level.f_46443_) {
                return;
            }
            WeightedRandomList<WeightedEntry.Wrapper<BlockState>> pallete = BuildingToolItem.getPallete(stack);
            if (!pallete.m_146337_()) {
                BlockState messageState;
                double integrity = BuildingToolItem.getProperty(stack, ToolModeProperty.INTEGRITY);
                ToolModeProperty.Replace replace = BuildingToolItem.getProperty(stack, ToolModeProperty.REPLACE);
                BlockState clickedState = level.m_8055_(clickedPos);
                ActionHistory.ActionBuilder action = ActionHistory.newAction();
                RandomSource rand = level.m_213780_();
                Set<BlockPos> poses = 8.getLinePositions(cornerA, cornerB);
                int total = 0;
                for (BlockPos pos : poses) {
                    Optional opState;
                    if (!((double)rand.m_188501_() < integrity) || !replace.shouldReplace(level, clickedState, pos) || !(opState = pallete.m_216829_(rand)).isPresent() || !this.setBlock(level, pos, (BlockState)((WeightedEntry.Wrapper)opState.get()).m_146310_(), action)) continue;
                    ++total;
                }
                ActionHistory.getOrCreateHistory(player).add(level, action);
                BlockState blockState = messageState = pallete.m_146338_().size() > 0 ? (BlockState)((WeightedEntry.Wrapper)pallete.m_146338_().get(0)).m_146310_() : Blocks.f_50069_.m_49966_();
                BuildingToolMode.sendMessage(player, replace == ToolModeProperty.Replace.ALL ? BuildingToolModes.PLACE_BLOCKS_KEY : (pallete.m_146338_().size() == 1 ? BuildingToolModes.REPLACE_BLOCKS_WITH_KEY : BuildingToolModes.REPLACE_BLOCKS_KEY), total, pallete.m_146338_().size() == 1 ? messageState.m_60734_().m_49954_().getString() : "");
                if (total > 0) {
                    BuildingToolMode.playSound(player, messageState);
                }
            } else {
                BuildingToolMode.sendMessage(player, BuildingToolModes.MISSING_STATE_KEY, Style.f_131099_.m_131140_(ChatFormatting.RED), new Object[0]);
            }
        }

        @Override
        public Object[] getDescArgs() {
            Options options = Minecraft.m_91087_().f_91066_;
            String shift = SGText.keybindString(options.f_92090_);
            String middleClick = SGText.keybindString(options.f_92097_);
            String rightClick = SGText.keybindString(options.f_92095_);
            String leftClick = SGText.keybindString(options.f_92096_);
            return new Object[]{middleClick, Component.m_237110_((String)BuildingToolModes.SELECT_POSITIONS, (Object[])new Object[]{rightClick, shift, rightClick}), leftClick};
        }

        @Override
        public void addProperties(List<ToolModeProperty<?>> properties) {
            super.addProperties(properties);
            properties.add(ToolModeProperty.INTEGRITY);
            properties.add(ToolModeProperty.REPLACE);
        }

        @Override
        public boolean hasBlockPalette() {
            return true;
        }

        @Override
        public void setPosition(Player player, BlockPos clickedPos, ItemStack stack, boolean message) {
            super.setPosition(player, clickedPos, stack, message);
            if (BuildingToolItem.hasCompleteSelection(stack)) {
                BlockPos a = BuildingToolItem.getPos(stack, 0).get();
                BlockPos b = BuildingToolItem.getPos(stack, 1).get();
                DecimalFormat format = new DecimalFormat("0.##");
                Double dist = a.m_252807_().m_82554_(b.m_252807_()) + 1.0;
                BuildingToolMode.sendMessage(player, BuildingToolModes.LENGTH_KEY, format.format(dist), 8.getLinePositions(a, b).size());
            }
        }
    });
    public static final BuildingToolMode SHAPE = BuildingToolModes.register(new BuildingToolMode("shape", 8){

        @Override
        public void onLeftClick(Level level, Player player, BlockPos clickedPos, ItemStack stack, Direction clickedFace) {
            if (level.f_46443_) {
                return;
            }
            WeightedRandomList<WeightedEntry.Wrapper<BlockState>> pallete = BuildingToolItem.getPallete(stack);
            if (!pallete.m_146337_()) {
                BlockState messageState;
                double integrity = BuildingToolItem.getProperty(stack, ToolModeProperty.INTEGRITY);
                int radius = BuildingToolItem.getProperty(stack, ToolModeProperty.RADIUS);
                ToolModeProperty.Shape shape = BuildingToolItem.getProperty(stack, ToolModeProperty.SHAPE);
                ToolModeProperty.Replace replace = BuildingToolItem.getProperty(stack, ToolModeProperty.REPLACE);
                BlockState clickedState = level.m_8055_(clickedPos);
                ActionHistory.ActionBuilder action = ActionHistory.newAction();
                RandomSource rand = level.m_213780_();
                int total = this.forPosesWithin((Vec3i)clickedPos.m_7918_(-radius, -radius, -radius), (Vec3i)clickedPos.m_7918_(radius, radius, radius), pos -> {
                    Optional opState;
                    if ((double)rand.m_188501_() < integrity && shape.isInside((Vec3i)clickedPos.m_7918_(-pos.m_123341_(), -pos.m_123342_(), -pos.m_123343_()), radius) && replace.shouldReplace(level, clickedState, (BlockPos)pos) && (opState = pallete.m_216829_(rand)).isPresent()) {
                        return this.setBlock(level, (BlockPos)pos, (BlockState oldState) -> replace == ToolModeProperty.Replace.CLICKED_BLOCK ? IModifyState.mergeStates((BlockState)((WeightedEntry.Wrapper)opState.get()).m_146310_(), oldState) : (BlockState)((WeightedEntry.Wrapper)opState.get()).m_146310_(), action);
                    }
                    return false;
                });
                ActionHistory.getOrCreateHistory(player).add(level, action);
                BlockState blockState = messageState = pallete.m_146338_().size() > 0 ? (BlockState)((WeightedEntry.Wrapper)pallete.m_146338_().get(0)).m_146310_() : Blocks.f_50069_.m_49966_();
                BuildingToolMode.sendMessage(player, replace == ToolModeProperty.Replace.ALL ? BuildingToolModes.PLACE_BLOCKS_KEY : (pallete.m_146338_().size() == 1 ? BuildingToolModes.REPLACE_BLOCKS_WITH_KEY : BuildingToolModes.REPLACE_BLOCKS_KEY), total, pallete.m_146338_().size() == 1 ? messageState.m_60734_().m_49954_().getString() : "");
                if (total > 0) {
                    BuildingToolMode.playSound(player, messageState);
                }
            } else {
                BuildingToolMode.sendMessage(player, BuildingToolModes.MISSING_STATE_KEY, Style.f_131099_.m_131140_(ChatFormatting.RED), new Object[0]);
            }
        }

        @Override
        public int getReachDistance(ItemStack stack) {
            int radius = BuildingToolItem.getProperty(stack, ToolModeProperty.RADIUS);
            return 2 + radius;
        }

        @Override
        public Object[] getDescArgs() {
            Options options = Minecraft.m_91087_().f_91066_;
            String middleClick = SGText.keybindString(options.f_92097_);
            String leftClick = SGText.keybindString(options.f_92096_);
            return new Object[]{middleClick, leftClick};
        }

        @Override
        public void addProperties(List<ToolModeProperty<?>> properties) {
            super.addProperties(properties);
            properties.add(ToolModeProperty.INTEGRITY);
            properties.add(ToolModeProperty.RADIUS);
            properties.add(ToolModeProperty.SHAPE);
            properties.add(ToolModeProperty.REPLACE);
        }

        @Override
        public boolean hasBlockPalette() {
            return true;
        }
    });

    public static void init() {
        REGISTRY.init();
    }

    protected static <T extends BuildingToolMode> T register(T mode) {
        REGISTRY.register(mode.name, mode);
        return mode;
    }
}

