/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.network;

import com.legacy.structure_gel.core.item.building_tool.ActionHistory;
import com.legacy.structure_gel.core.item.building_tool.BuildingToolBounds;
import com.legacy.structure_gel.core.network.PacketHandler;
import com.legacy.structure_gel.core.network.PlaySoundPacket;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class ActionHistoryPacket {
    private final Action action;
    private final InteractionHand hand;
    private final boolean playSound;

    private ActionHistoryPacket(Action action, InteractionHand hand, boolean playSound) {
        this.action = action;
        this.hand = hand;
        this.playSound = playSound;
    }

    public static ActionHistoryPacket undo(boolean playSound) {
        return new ActionHistoryPacket(Action.UNDO, InteractionHand.MAIN_HAND, playSound);
    }

    public static ActionHistoryPacket redo(boolean playSound) {
        return new ActionHistoryPacket(Action.REDO, InteractionHand.MAIN_HAND, playSound);
    }

    public static ActionHistoryPacket releaseGrabbedCorner(InteractionHand hand) {
        return new ActionHistoryPacket(Action.RELEASE_GRABBED_CORNER, hand, false);
    }

    public static void encoder(ActionHistoryPacket packet, FriendlyByteBuf buff) {
        buff.writeInt(packet.action.ordinal());
        buff.writeBoolean(packet.hand == InteractionHand.MAIN_HAND);
        buff.writeBoolean(packet.playSound);
    }

    public static ActionHistoryPacket decoder(FriendlyByteBuf buff) {
        return new ActionHistoryPacket(Action.get(buff.readInt()), buff.readBoolean() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND, buff.readBoolean());
    }

    public static void handler(ActionHistoryPacket packet, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
            ActionHistory history = ActionHistory.getOrCreateHistory((Player)player);
            boolean succeeded = false;
            if (packet.action == Action.UNDO) {
                succeeded = history.undo(player);
            } else if (packet.action == Action.REDO) {
                succeeded = history.redo(player);
            } else if (packet.action == Action.RELEASE_GRABBED_CORNER) {
                BuildingToolBounds.releaseGrabbedCorner(player.m_21120_(packet.hand), (Player)player);
            }
            if (succeeded && packet.playSound) {
                PacketHandler.sendToClient(new PlaySoundPacket(0), player);
            }
        });
        context.get().setPacketHandled(true);
    }

    public static enum Action {
        NONE,
        UNDO,
        REDO,
        RELEASE_GRABBED_CORNER;


        public static Action get(int id) {
            Action[] actions = Action.values();
            if (id > -1 && id < actions.length) {
                return actions[id];
            }
            return NONE;
        }
    }
}

