/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.network;

import com.legacy.structure_gel.api.data_handler.handlers.DataHandler;
import com.legacy.structure_gel.core.StructureGelMod;
import com.legacy.structure_gel.core.block_entity.DataHandlerBlockEntity;
import com.legacy.structure_gel.core.registry.SGRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.Weight;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraftforge.network.NetworkEvent;

public record UpdateDataHandlerPacket(byte mode, BlockPos pos, List<DataHandlerBlockEntity.RawHandler> handlers) {
    public static void encoder(UpdateDataHandlerPacket packet, FriendlyByteBuf buff) {
        buff.writeByte((int)packet.mode);
        buff.m_130064_(packet.pos);
        buff.writeInt(packet.handlers.size());
        for (DataHandlerBlockEntity.RawHandler handler : packet.handlers) {
            buff.writeInt(handler.m_142631_().m_146281_());
            buff.m_130085_(handler.typeName());
            buff.writeInt(handler.dataEntries().size());
            for (Map.Entry<String, String> entry : handler.dataEntries().entrySet()) {
                buff.m_130070_(entry.getKey());
                buff.m_130070_(entry.getValue());
            }
        }
    }

    public static UpdateDataHandlerPacket decoder(FriendlyByteBuf buff) {
        try {
            byte mode = buff.readByte();
            BlockPos pos = buff.m_130135_();
            ArrayList<DataHandlerBlockEntity.RawHandler> handlers = new ArrayList<DataHandlerBlockEntity.RawHandler>();
            int size = buff.readInt();
            for (int i = 0; i < size; ++i) {
                Weight weight = Weight.m_146282_((int)buff.readInt());
                ResourceLocation type = buff.m_130281_();
                LinkedHashMap<String, String> dataEntries = new LinkedHashMap<String, String>();
                int entrySize = buff.readInt();
                for (int e = 0; e < entrySize; ++e) {
                    dataEntries.put(buff.m_130277_(), buff.m_130277_());
                }
                handlers.add(new DataHandlerBlockEntity.RawHandler(weight, type, dataEntries));
            }
            return new UpdateDataHandlerPacket(mode, pos, handlers);
        }
        catch (Throwable t) {
            return new UpdateDataHandlerPacket(-1, BlockPos.f_121853_, Collections.emptyList());
        }
    }

    public static void handler(UpdateDataHandlerPacket packet, Supplier<NetworkEvent.Context> context) {
        if (packet.mode == -1) {
            ServerPlayer sender = context.get().getSender();
            StructureGelMod.LOGGER.warn("An invalid packet ({}) was sent to the server from {} at {} in {}", packet.getClass().getSimpleName(), sender.m_36316_().getName(), sender.m_20183_(), sender.f_19853_.m_46472_().m_135782_());
            return;
        }
        context.get().enqueueWork(() -> {
            ServerLevel level = ((NetworkEvent.Context)context.get()).getSender().m_9236_();
            BlockPos pos = packet.pos;
            BlockEntity blockEntity = level.m_7702_(pos);
            BlockState state = level.m_8055_(pos);
            if (state.m_60734_() == SGRegistry.Blocks.DATA_HANDLER.get() && blockEntity instanceof DataHandlerBlockEntity) {
                DataHandlerBlockEntity dataHandler = (DataHandlerBlockEntity)blockEntity;
                dataHandler.setHandlers((WeightedRandomList<DataHandlerBlockEntity.RawHandler>)WeightedRandomList.m_146328_(packet.handlers));
                blockEntity.m_6596_();
                level.m_7260_(pos, state, state, 3);
                if (packet.mode == 1) {
                    ItemEntity itemEntity;
                    ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
                    Item item = SGRegistry.Blocks.DATA_HANDLER.get().m_5456_();
                    ItemStack stack = new ItemStack((ItemLike)item);
                    blockEntity.m_187476_(stack);
                    boolean hasItem = false;
                    for (ItemStack invStack : player.m_150109_().f_35974_) {
                        if (invStack.m_41619_() || invStack.m_41720_() != item) continue;
                        ItemStack cloneInvStack = invStack.m_41777_();
                        CompoundTag tag = cloneInvStack.m_41783_();
                        if (tag != null && tag.m_128425_("display", 10)) {
                            tag.m_128473_("display");
                        }
                        if (!cloneInvStack.equals(stack, true)) continue;
                        hasItem = true;
                        break;
                    }
                    if (!hasItem && (itemEntity = player.m_36176_(stack, false)) != null) {
                        itemEntity.m_32061_();
                        itemEntity.m_32047_(player.m_20148_());
                    }
                    int offsetAmt = 8;
                    BoundingBox bounds = BoundingBox.m_162375_((Vec3i)pos.m_7918_(-offsetAmt, -offsetAmt, -offsetAmt), (Vec3i)pos.m_7918_(offsetAmt, offsetAmt, offsetAmt));
                    DataHandler.process(state, dataHandler.m_187480_(), pos, (WorldGenLevel)level, level.f_46441_, bounds, new DummyPiece(bounds), true);
                }
            } else {
                StructureGelMod.LOGGER.warn("Attempted to set DataHandlerBlockEntity data for the wrong block.", new Object[0]);
            }
        });
        context.get().setPacketHandled(true);
    }

    private static final class DummyPiece
    extends StructurePiece {
        protected DummyPiece(BoundingBox bounds) {
            super(StructurePieceType.f_210125_, 0, bounds);
            this.m_73519_(Direction.NORTH);
        }

        protected void m_183620_(StructurePieceSerializationContext context, CompoundTag tag) {
        }

        public void m_213694_(WorldGenLevel level, StructureManager structureManager, ChunkGenerator chunkGen, RandomSource rand, BoundingBox bounds, ChunkPos chunkPos, BlockPos pos) {
        }
    }
}

