/*
 * Decompiled with CFR 0.152.
 */
package com.finndog.mvs.utils;

import java.util.ArrayList;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.Structure;

public class StructureUtils {
    public static boolean isAllowedTerrainHeightChange(Structure.GenerationContext context, int size, int allowedTerrainHeightRange) {
        ChunkPos pos = context.f_226628_();
        int[] cornerHeights = StructureUtils.getCornerHeights(context, pos.m_45604_(), size, pos.m_45605_(), size);
        int minHeight = Math.min(Math.min(cornerHeights[0], cornerHeights[1]), Math.min(cornerHeights[2], cornerHeights[3]));
        int maxHeight = Math.max(Math.max(cornerHeights[0], cornerHeights[1]), Math.max(cornerHeights[2], cornerHeights[3]));
        return Math.abs(maxHeight - minHeight) <= allowedTerrainHeightRange;
    }

    public static int[] getCornerHeights(Structure.GenerationContext context, int middleBlockX, int xSize, int middleBlockZ, int zSize) {
        ChunkGenerator generator = context.f_226622_();
        LevelHeightAccessor heightAccessor = context.f_226629_();
        RandomState randomState = context.f_226624_();
        return new int[]{generator.m_223235_(middleBlockX, middleBlockZ, Heightmap.Types.WORLD_SURFACE_WG, heightAccessor, randomState), generator.m_223235_(middleBlockX, middleBlockZ + zSize, Heightmap.Types.WORLD_SURFACE_WG, heightAccessor, randomState), generator.m_223235_(middleBlockX + xSize, middleBlockZ, Heightmap.Types.WORLD_SURFACE_WG, heightAccessor, randomState), generator.m_223235_(middleBlockX + xSize, middleBlockZ + zSize, Heightmap.Types.WORLD_SURFACE_WG, heightAccessor, randomState)};
    }

    public static boolean onLiquid(Structure.GenerationContext context, boolean spawnInLiquid) {
        ChunkPos chunkPos = context.f_226628_();
        BlockPos centerOfChunk = chunkPos.m_151394_(0);
        int landHeight = context.f_226622_().m_223235_(centerOfChunk.m_123341_(), centerOfChunk.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, context.f_226629_(), context.f_226624_());
        NoiseColumn columnOfBlocks = context.f_226622_().m_214184_(centerOfChunk.m_123341_(), centerOfChunk.m_123343_(), context.f_226629_(), context.f_226624_());
        BlockState topBlock = columnOfBlocks.m_183556_(centerOfChunk.m_123342_() + landHeight);
        if (spawnInLiquid) {
            return !topBlock.m_60819_().m_76178_();
        }
        return topBlock.m_60819_().m_76178_();
    }

    public static Optional<Integer> getSuitableNetherYLevel(Structure.GenerationContext context, BlockPos pos) {
        NoiseColumn column = context.f_226622_().m_214184_(pos.m_123341_(), pos.m_123343_(), context.f_226629_(), context.f_226624_());
        ArrayList<Integer> suitableYLevels = new ArrayList<Integer>();
        for (int y = 127; y > context.f_226622_().m_6337_(); --y) {
            if (!column.m_183556_(y - 1).m_60815_() || !column.m_183556_(y).m_60795_() || !column.m_183556_(y + 4).m_60795_()) continue;
            suitableYLevels.add(y);
        }
        if (suitableYLevels.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of((Integer)suitableYLevels.get(new Random(context.f_226627_()).nextInt(suitableYLevels.size())));
    }
}

