/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.chiseling.modes.replace;

import com.communi.suggestu.scena.core.registries.AbstractCustomRegistryEntry;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import mod.chiselsandbits.api.axissize.CollisionType;
import mod.chiselsandbits.api.blockinformation.IBlockInformation;
import mod.chiselsandbits.api.change.IChangeTrackerManager;
import mod.chiselsandbits.api.chiseling.ChiselingOperation;
import mod.chiselsandbits.api.chiseling.IChiselingContext;
import mod.chiselsandbits.api.chiseling.mode.IChiselMode;
import mod.chiselsandbits.api.inventory.bit.IBitInventory;
import mod.chiselsandbits.api.inventory.management.IBitInventoryManager;
import mod.chiselsandbits.api.item.click.ClickProcessingState;
import mod.chiselsandbits.api.item.withmode.group.IToolModeGroup;
import mod.chiselsandbits.api.multistate.StateEntrySize;
import mod.chiselsandbits.api.multistate.accessor.IAreaAccessor;
import mod.chiselsandbits.api.multistate.accessor.IStateEntryInfo;
import mod.chiselsandbits.api.multistate.mutator.IMutatorFactory;
import mod.chiselsandbits.api.multistate.mutator.world.IWorldAreaMutator;
import mod.chiselsandbits.api.util.IBatchMutation;
import mod.chiselsandbits.api.util.LambdaExceptionUtils;
import mod.chiselsandbits.api.util.LocalStrings;
import mod.chiselsandbits.api.util.RayTracingUtils;
import mod.chiselsandbits.registrars.ModMetadataKeys;
import mod.chiselsandbits.utils.BitInventoryUtils;
import mod.chiselsandbits.utils.ItemStackUtils;
import mod.chiselsandbits.voxelshape.VoxelShapeManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class ReplaceChiselingMode
extends AbstractCustomRegistryEntry
implements IChiselMode {
    private final MutableComponent displayName;
    private final MutableComponent multiLineDisplayName;
    private final ResourceLocation iconName;

    public ReplaceChiselingMode(MutableComponent displayName, MutableComponent multiLineDisplayName, ResourceLocation iconName) {
        this.displayName = displayName;
        this.multiLineDisplayName = multiLineDisplayName;
        this.iconName = iconName;
    }

    @Override
    public ClickProcessingState onLeftClickBy(Player player, IChiselingContext context) {
        Optional<ClickProcessingState> rayTraceHandle = this.processRayTraceIntoContext(player, context);
        if (context.isSimulation()) {
            return ClickProcessingState.DEFAULT;
        }
        return rayTraceHandle.orElseGet(() -> context.getMutator().map(mutator -> {
            try (IBatchMutation ignored = mutator.batch(IChangeTrackerManager.getInstance().getChangeTracker(player));){
                IBlockInformation heldBlockState = ItemStackUtils.getHeldBitBlockInformationFromPlayer(player);
                if (heldBlockState.isAir()) {
                    ClickProcessingState clickProcessingState = ClickProcessingState.DEFAULT;
                    return clickProcessingState;
                }
                context.setComplete();
                HashMap resultingBitCount = Maps.newHashMap();
                Predicate<IStateEntryInfo> filter = context.getStateFilter().map(builder -> (Predicate)builder.apply(mutator)).orElse(state -> true);
                int missingBitCount = (int)mutator.stream().filter(filter).count();
                IBitInventory playerBitInventory = IBitInventoryManager.getInstance().create(player);
                if (!player.m_7500_() && !playerBitInventory.canExtract(heldBlockState, missingBitCount)) {
                    context.setError(LocalStrings.ChiselAttemptFailedNotEnoughBits.getText(heldBlockState.getBlockState().m_60734_().m_49954_()));
                    ClickProcessingState clickProcessingState = ClickProcessingState.DEFAULT;
                    return clickProcessingState;
                }
                int totalModifiedStates = mutator.inWorldMutableStream().filter(filter).mapToInt(LambdaExceptionUtils.rethrowToIntFunction(state -> {
                    IBlockInformation currentState = state.getBlockInformation();
                    return context.tryDamageItemAndDoOrSetBrokenError(() -> {
                        resultingBitCount.putIfAbsent(currentState, 0);
                        resultingBitCount.computeIfPresent(currentState, (s, currentCount) -> currentCount + 1);
                        state.overrideState(heldBlockState);
                    });
                })).sum();
                if (totalModifiedStates == 0) {
                    context.setError(LocalStrings.ChiselAttemptFailedNoValidStateFound.getText());
                }
                if (!player.m_7500_()) {
                    playerBitInventory.extract(heldBlockState, missingBitCount);
                }
                resultingBitCount.forEach((blockState, count) -> BitInventoryUtils.insertIntoOrSpawn(player, blockState, count));
            }
            return ClickProcessingState.ALLOW;
        }).orElse(ClickProcessingState.DEFAULT));
    }

    @Override
    public void onStoppedLeftClicking(Player Player2, IChiselingContext context) {
    }

    @Override
    public ClickProcessingState onRightClickBy(Player Player2, IChiselingContext context) {
        return this.onLeftClickBy(Player2, context);
    }

    @Override
    public void onStoppedRightClicking(Player Player2, IChiselingContext context) {
    }

    @Override
    public boolean isStillValid(Player Player2, IChiselingContext context, ChiselingOperation modeOfOperation) {
        Optional<Set<Vec3i>> validPositions = context.getMetadata(ModMetadataKeys.VALID_POSITIONS.get());
        Optional<Direction> targetedSide = context.getMetadata(ModMetadataKeys.TARGETED_SIDE.get());
        Optional<BlockPos> targetedBlockPos = context.getMetadata(ModMetadataKeys.TARGETED_BLOCK.get());
        if (validPositions.isEmpty() || targetedSide.isEmpty() || targetedBlockPos.isEmpty()) {
            return false;
        }
        HitResult hitResult = RayTracingUtils.rayTracePlayer(Player2);
        if (hitResult.m_6662_() != HitResult.Type.BLOCK || !(hitResult instanceof BlockHitResult)) {
            return false;
        }
        BlockHitResult blockHitResult = (BlockHitResult)hitResult;
        if (blockHitResult.m_82434_() != targetedSide.get()) {
            return false;
        }
        Function<Direction, Vec3> placementFacingAdapter = modeOfOperation == ChiselingOperation.CHISELING ? face -> Vec3.m_82528_((Vec3i)face.m_122424_().m_122436_()) : face -> Vec3.m_82528_((Vec3i)face.m_122436_());
        Vec3 hitVector = blockHitResult.m_82450_().m_82549_(placementFacingAdapter.apply(blockHitResult.m_82434_()).m_82542_((double)StateEntrySize.current().getSizePerHalfBit(), (double)StateEntrySize.current().getSizePerHalfBit(), (double)StateEntrySize.current().getSizePerHalfBit()));
        BlockPos hitPos = new BlockPos(hitVector);
        Vec3 hitBlockPosVector = Vec3.m_82528_((Vec3i)hitPos);
        Vec3 inBlockHitVector = hitVector.m_82546_(hitBlockPosVector);
        Vec3i selectedPosition = new Vec3i(inBlockHitVector.m_7096_() * (double)StateEntrySize.current().getBitsPerBlockSide(), inBlockHitVector.m_7098_() * (double)StateEntrySize.current().getBitsPerBlockSide(), inBlockHitVector.m_7094_() * (double)StateEntrySize.current().getBitsPerBlockSide());
        return validPositions.get().contains(selectedPosition) && hitPos.equals((Object)targetedBlockPos.get());
    }

    @Override
    public Optional<IAreaAccessor> getCurrentAccessor(IChiselingContext context) {
        return context.getMutator().map(mutator -> mutator);
    }

    private Optional<ClickProcessingState> processRayTraceIntoContext(Player Player2, IChiselingContext context) {
        HitResult hitResult = RayTracingUtils.rayTracePlayer(Player2);
        if (hitResult.m_6662_() != HitResult.Type.BLOCK || !(hitResult instanceof BlockHitResult)) {
            context.setError(LocalStrings.ChiselAttemptFailedNoBlock.getText());
            return Optional.of(ClickProcessingState.DEFAULT);
        }
        BlockHitResult blockHitResult = (BlockHitResult)hitResult;
        Function<Direction, Vec3> placementFacingAdapter = face -> Vec3.m_82528_((Vec3i)face.m_122424_().m_122436_());
        Vec3 hitVector = blockHitResult.m_82450_().m_82549_(placementFacingAdapter.apply(blockHitResult.m_82434_()).m_82542_((double)StateEntrySize.current().getSizePerHalfBit(), (double)StateEntrySize.current().getSizePerHalfBit(), (double)StateEntrySize.current().getSizePerHalfBit()));
        BlockPos hitPos = new BlockPos(hitVector);
        Vec3 hitBlockPosVector = Vec3.m_82528_((Vec3i)hitPos);
        Vec3 inBlockHitVector = hitVector.m_82546_(hitBlockPosVector);
        LinkedList<Vec3i> toProcess = new LinkedList<Vec3i>();
        IWorldAreaMutator worldAccessor = IMutatorFactory.getInstance().in(context.getWorld(), hitPos);
        HashSet validPositions = new HashSet();
        Vec3i selectedPosition = new Vec3i(inBlockHitVector.m_7096_() * (double)StateEntrySize.current().getBitsPerBlockSide(), inBlockHitVector.m_7098_() * (double)StateEntrySize.current().getBitsPerBlockSide(), inBlockHitVector.m_7094_() * (double)StateEntrySize.current().getBitsPerBlockSide());
        toProcess.addLast(selectedPosition);
        Vec3 selectedInBlockPosition = Vec3.m_82528_((Vec3i)selectedPosition).m_82559_(StateEntrySize.current().getSizePerBitScalingVector());
        Optional<IStateEntryInfo> targetedInfo = worldAccessor.getInAreaTarget(selectedInBlockPosition);
        if (targetedInfo.isEmpty()) {
            context.setError(LocalStrings.ChiselAttemptFailedTargetedBlockNotChiselable.getText());
            return Optional.of(ClickProcessingState.DEFAULT);
        }
        worldAccessor.stream().filter(state -> state.getBlockInformation().equals(((IStateEntryInfo)targetedInfo.get()).getBlockInformation())).map(state -> state.getStartPoint().m_82559_(StateEntrySize.current().getBitsPerBlockSideScalingVector())).map(position -> new Vec3i(position.m_7096_(), position.m_7098_(), position.m_7094_())).forEach(validPositions::add);
        context.include(hitPos, Vec3.f_82478_);
        context.include(hitPos, new Vec3(0.9999, 0.9999, 0.9999));
        context.setStateFilter(accessor -> new SelectedBitStateFilter(validPositions));
        context.setMetadata(ModMetadataKeys.VALID_POSITIONS.get(), validPositions);
        context.setMetadata(ModMetadataKeys.TARGETED_SIDE.get(), blockHitResult.m_82434_());
        context.setMetadata(ModMetadataKeys.TARGETED_BLOCK.get(), hitPos);
        return Optional.empty();
    }

    @Override
    public boolean requiresPlaceableEditStack() {
        return true;
    }

    @Override
    public VoxelShape getShape(IChiselingContext context) {
        if (context.getMutator().isEmpty()) {
            return Shapes.m_83040_();
        }
        return VoxelShapeManager.getInstance().get((IAreaAccessor)context.getMutator().get(), CollisionType.ALL);
    }

    @Override
    @NotNull
    public ResourceLocation getIcon() {
        return this.iconName;
    }

    @Override
    @NotNull
    public Optional<IToolModeGroup> getGroup() {
        return Optional.empty();
    }

    @Override
    public Component getDisplayName() {
        return this.displayName;
    }

    @Override
    public Component getMultiLineDisplayName() {
        return this.multiLineDisplayName;
    }

    private static final class SelectedBitStateFilter
    implements Predicate<IStateEntryInfo> {
        private final Set<Vec3i> validPositions;

        public SelectedBitStateFilter(Set<Vec3i> validPositions) {
            this.validPositions = validPositions;
        }

        @Override
        public boolean test(IStateEntryInfo iStateEntryInfo) {
            Vec3i position = new Vec3i(iStateEntryInfo.getStartPoint().m_7096_() * (double)StateEntrySize.current().getBitsPerBlockSide(), iStateEntryInfo.getStartPoint().m_7098_() * (double)StateEntrySize.current().getBitsPerBlockSide(), iStateEntryInfo.getStartPoint().m_7094_() * (double)StateEntrySize.current().getBitsPerBlockSide());
            return this.validPositions.contains(position);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SelectedBitStateFilter)) {
                return false;
            }
            SelectedBitStateFilter that = (SelectedBitStateFilter)o;
            return this.validPositions.equals(that.validPositions);
        }

        public int hashCode() {
            return this.validPositions.hashCode();
        }

        public String toString() {
            return "SelectedBitStateFilter{validPositions=" + this.validPositions + "}";
        }
    }
}

