/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client.model.baked.base;

import com.communi.suggestu.scena.core.client.models.baked.ITransformAwareBakedModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Transformation;
import mod.chiselsandbits.client.util.TransformationUtils;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.resources.model.BakedModel;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public abstract class BaseBakedPerspectiveModel
implements BakedModel,
ITransformAwareBakedModel {
    private static final Transformation ground;
    private static final Transformation gui;
    private static final Transformation fixed;
    private static final Transformation firstPerson_righthand;
    private static final Transformation firstPerson_lefthand;
    private static final Transformation thirdPerson_righthand;
    private static final Transformation thirdPerson_lefthand;

    private static Transformation getMatrix(float transX, float transY, float transZ, float rotX, float rotY, float rotZ, float scaleXYZ) {
        Vector3f translation = new Vector3f(transX, transY, transZ);
        Vector3f scale = new Vector3f(scaleXYZ, scaleXYZ, scaleXYZ);
        Quaternionf rotation = com.communi.suggestu.scena.core.util.TransformationUtils.quatFromXYZ((Vector3f)new Vector3f(rotX, rotY, rotZ), (boolean)true);
        return new Transformation(translation, rotation, scale, null);
    }

    @NotNull
    public ItemTransforms m_7442_() {
        return new PerspectiveHandlingItemTransforms(this);
    }

    public BakedModel handlePerspective(ItemTransforms.TransformType cameraTransformType, PoseStack mat) {
        this.doCameraTransformForType(cameraTransformType, mat, true);
        return this;
    }

    private void doCameraTransformForType(ItemTransforms.TransformType cameraTransformType, PoseStack mat, boolean requiresStackPush) {
        switch (cameraTransformType) {
            case FIRST_PERSON_LEFT_HAND: {
                TransformationUtils.push(mat, firstPerson_lefthand, requiresStackPush);
                break;
            }
            case FIRST_PERSON_RIGHT_HAND: {
                TransformationUtils.push(mat, firstPerson_righthand, requiresStackPush);
                break;
            }
            case THIRD_PERSON_LEFT_HAND: {
                TransformationUtils.push(mat, thirdPerson_lefthand, requiresStackPush);
                break;
            }
            case THIRD_PERSON_RIGHT_HAND: {
                TransformationUtils.push(mat, thirdPerson_righthand, requiresStackPush);
                break;
            }
            case GROUND: {
                TransformationUtils.push(mat, ground, requiresStackPush);
                break;
            }
            case GUI: {
                TransformationUtils.push(mat, gui, requiresStackPush);
                break;
            }
            default: {
                TransformationUtils.push(mat, fixed, requiresStackPush);
            }
        }
    }

    static {
        gui = BaseBakedPerspectiveModel.getMatrix(0.0f, 0.0f, 0.0f, 30.0f, 225.0f, 0.0f, 0.625f);
        ground = BaseBakedPerspectiveModel.getMatrix(0.0f, 0.1875f, 0.0f, 0.0f, 0.0f, 0.0f, 0.25f);
        fixed = BaseBakedPerspectiveModel.getMatrix(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f);
        thirdPerson_lefthand = thirdPerson_righthand = BaseBakedPerspectiveModel.getMatrix(0.0f, 0.15625f, 0.0f, 75.0f, 45.0f, 0.0f, 0.375f);
        firstPerson_righthand = firstPerson_lefthand = BaseBakedPerspectiveModel.getMatrix(0.0f, 0.0f, 0.0f, 0.0f, 45.0f, 0.0f, 0.4f);
    }

    private static final class PerspectiveHandlingItemTransforms
    extends ItemTransforms {
        private final BaseBakedPerspectiveModel transformAwareBakedModel;

        public PerspectiveHandlingItemTransforms(BaseBakedPerspectiveModel transformAwareBakedModel) {
            super(ItemTransform.f_111754_, ItemTransform.f_111754_, ItemTransform.f_111754_, ItemTransform.f_111754_, ItemTransform.f_111754_, ItemTransform.f_111754_, ItemTransform.f_111754_, ItemTransform.f_111754_);
            this.transformAwareBakedModel = transformAwareBakedModel;
        }

        @NotNull
        public ItemTransform m_111808_(final @NotNull ItemTransforms.TransformType transformType) {
            return new ItemTransform(new Vector3f(), new Vector3f(), new Vector3f()){

                public void m_111763_(boolean isLeftHand, @NotNull PoseStack poseStack) {
                    transformAwareBakedModel.doCameraTransformForType(transformType, poseStack, false);
                }
            };
        }
    }
}

