/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client.multistate.rendering;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import mod.chiselsandbits.api.blockinformation.IBlockInformation;
import mod.chiselsandbits.api.multistate.accessor.IAreaAccessor;
import mod.chiselsandbits.api.multistate.accessor.IStateEntryInfo;
import mod.chiselsandbits.api.multistate.accessor.identifier.IAreaShapeIdentifier;
import mod.chiselsandbits.api.multistate.accessor.sortable.IPositionMutator;
import mod.chiselsandbits.api.multistate.snapshot.IMultiStateSnapshot;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.NotImplementedException;
import org.jetbrains.annotations.NotNull;

public class RenderingAreaAccessor
implements IAreaAccessor {
    private final IBlockInformation filter;
    private final IAreaAccessor wrapped;

    public RenderingAreaAccessor(IBlockInformation filter, IAreaAccessor wrapped) {
        this.filter = filter;
        this.wrapped = wrapped;
    }

    @Override
    @NotNull
    public AABB getBoundingBox() {
        return this.wrapped.getBoundingBox();
    }

    @Override
    public IAreaShapeIdentifier createNewShapeIdentifier() {
        return new AreaShapeIdentifier(this.filter, this.wrapped.createNewShapeIdentifier());
    }

    @Override
    public Stream<IStateEntryInfo> stream() {
        return this.wrapped.stream().filter(s -> s.getBlockInformation().equals(this.filter));
    }

    @Override
    public boolean isInside(Vec3 inAreaTarget) {
        return this.wrapped.isInside(inAreaTarget);
    }

    @Override
    public boolean isInside(BlockPos inAreaBlockPosOffset, Vec3 inBlockTarget) {
        return this.wrapped.isInside(inAreaBlockPosOffset, inBlockTarget);
    }

    @Override
    public IMultiStateSnapshot createSnapshot() {
        throw new NotImplementedException();
    }

    @Override
    public Stream<IStateEntryInfo> streamWithPositionMutator(IPositionMutator positionMutator) {
        return this.wrapped.streamWithPositionMutator(positionMutator).filter(s -> s.getBlockInformation().equals(this.filter));
    }

    @Override
    public void forEachWithPositionMutator(IPositionMutator positionMutator, final Consumer<IStateEntryInfo> consumer) {
        this.wrapped.forEachWithPositionMutator(positionMutator, new Consumer<IStateEntryInfo>(){

            @Override
            public void accept(IStateEntryInfo iStateEntryInfo) {
                if (iStateEntryInfo.getBlockInformation().equals(RenderingAreaAccessor.this.filter)) {
                    consumer.accept(iStateEntryInfo);
                }
            }
        });
    }

    @Override
    public Optional<IStateEntryInfo> getInAreaTarget(Vec3 inAreaTarget) {
        return this.wrapped.getInAreaTarget(inAreaTarget).filter(s -> s.getBlockInformation().equals(this.filter));
    }

    @Override
    public Optional<IStateEntryInfo> getInBlockTarget(BlockPos inAreaBlockPosOffset, Vec3 inBlockTarget) {
        return this.wrapped.getInBlockTarget(inAreaBlockPosOffset, inBlockTarget).filter(s -> s.getBlockInformation().equals(this.filter));
    }

    public static final class AreaShapeIdentifier
    implements IAreaShapeIdentifier {
        private final IBlockInformation filter;
        private final IAreaShapeIdentifier wrapped;

        public AreaShapeIdentifier(IBlockInformation filter, IAreaShapeIdentifier wrapped) {
            this.filter = filter;
            this.wrapped = wrapped;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AreaShapeIdentifier that = (AreaShapeIdentifier)o;
            return Objects.equals(this.filter, that.filter) && Objects.equals(this.wrapped, that.wrapped);
        }

        public int hashCode() {
            return Objects.hash(this.filter, this.wrapped);
        }
    }
}

