/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client.render;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Arrays;
import java.util.List;
import mod.chiselsandbits.api.client.render.preview.placement.PlacementPreviewRenderMode;
import mod.chiselsandbits.api.placement.PlacementResult;
import mod.chiselsandbits.client.render.ModRenderTypes;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector4f;
import org.lwjgl.system.MemoryStack;

public class ChiseledBlockGhostRenderer {
    private static final ChiseledBlockGhostRenderer INSTANCE = new ChiseledBlockGhostRenderer();
    private static final BufferBuilderTransparent BUFFER = new BufferBuilderTransparent();
    private static final float[] DIRECTIONAL_BRIGHTNESS = new float[]{0.5f, 1.0f, 0.7f, 0.7f, 0.6f, 0.6f};

    public static ChiseledBlockGhostRenderer getInstance() {
        return INSTANCE;
    }

    private ChiseledBlockGhostRenderer() {
    }

    public void renderGhost(PoseStack poseStack, ItemStack renderStack, Vec3 targetedRenderPos, PlacementResult placementResult, PlacementPreviewRenderMode success, PlacementPreviewRenderMode failure, boolean ignoreDepth) {
        poseStack.m_85836_();
        Vec3 camera = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        poseStack.m_85837_(targetedRenderPos.f_82479_ - camera.f_82479_ - 1.25E-4, targetedRenderPos.f_82480_ - camera.f_82480_ + 1.25E-4, targetedRenderPos.f_82481_ - camera.f_82481_ - 1.25E-4);
        poseStack.m_85841_(1.001f, 1.001f, 1.001f);
        Vector4f color = placementResult.getColor();
        boolean renderColoredGhost = placementResult.isSuccess() && success.isColoredGhost() || !placementResult.isSuccess() && failure.isColoredGhost();
        BUFFER.setAlphaPercentage(color.w());
        BakedModel model = Minecraft.m_91087_().m_91291_().m_174264_(renderStack, null, null, 0);
        if (!renderColoredGhost || !ignoreDepth) {
            this.renderGhost(poseStack, renderStack, model, renderColoredGhost, color, false);
        }
        if (ignoreDepth) {
            this.renderGhost(poseStack, renderStack, model, renderColoredGhost, color, true);
        }
        poseStack.m_85849_();
    }

    private void renderGhost(PoseStack poseStack, ItemStack renderStack, BakedModel model, boolean renderColoredGhost, Vector4f color, boolean ignoreDepth) {
        RenderType renderType = renderColoredGhost ? (ignoreDepth ? ModRenderTypes.GHOST_BLOCK_COLORED_PREVIEW_ALWAYS.get() : ModRenderTypes.GHOST_BLOCK_COLORED_PREVIEW.get()) : (ignoreDepth ? ModRenderTypes.GHOST_BLOCK_PREVIEW_GREATER.get() : ModRenderTypes.GHOST_BLOCK_PREVIEW.get());
        BUFFER.m_166779_(renderType.m_173186_(), renderType.m_110508_());
        if (renderColoredGhost) {
            ChiseledBlockGhostRenderer.renderModelLists(model, poseStack, (VertexConsumer)BUFFER, color);
        } else {
            Minecraft.m_91087_().m_91291_().m_115189_(model, renderStack, 0xF000F0, OverlayTexture.f_118083_, poseStack, (VertexConsumer)BUFFER);
        }
        renderType.m_110412_((BufferBuilder)BUFFER, 0, 0, 0);
    }

    private static Vector3f[] getShadedColors(Vector4f color) {
        return (Vector3f[])Arrays.stream(Direction.values()).map(direction -> {
            float brightness = DIRECTIONAL_BRIGHTNESS[direction.m_122411_()];
            return new Vector3f(color.x() * brightness, color.y() * brightness, color.z() * brightness);
        }).toArray(Vector3f[]::new);
    }

    private static Vector3f[] getNormals(PoseStack.Pose pose) {
        return (Vector3f[])Arrays.stream(Direction.values()).map(direction -> {
            Vec3i faceNormal = direction.m_122436_();
            Vector3f normal = new Vector3f((float)faceNormal.m_123341_(), (float)faceNormal.m_123342_(), (float)faceNormal.m_123343_());
            normal.mul((Matrix3fc)pose.m_252943_());
            return normal;
        }).toArray(Vector3f[]::new);
    }

    private static void renderModelLists(BakedModel model, PoseStack poseStack, VertexConsumer buffer, Vector4f color) {
        RandomSource random = RandomSource.m_216335_((long)42L);
        Vector3f[] normals = ChiseledBlockGhostRenderer.getNormals(poseStack.m_85850_());
        Vector3f[] shadedColors = ChiseledBlockGhostRenderer.getShadedColors(color);
        Vector4f pos = new Vector4f();
        for (Direction direction : Direction.values()) {
            random.m_188584_(42L);
            ChiseledBlockGhostRenderer.renderQuadList(poseStack.m_85850_().m_252922_(), buffer, model.m_213637_(null, direction, random), normals, shadedColors, pos);
        }
        random.m_188584_(42L);
        ChiseledBlockGhostRenderer.renderQuadList(poseStack.m_85850_().m_252922_(), buffer, model.m_213637_(null, null, random), normals, shadedColors, pos);
    }

    private static void renderQuadList(Matrix4f pose, VertexConsumer buffer, List<BakedQuad> quads, Vector3f[] normals, Vector3f[] shadedColors, Vector4f pos) {
        for (BakedQuad quad : quads) {
            ChiseledBlockGhostRenderer.putBulkData(buffer, pose, quad, shadedColors[quad.m_111306_().ordinal()], normals[quad.m_111306_().ordinal()], pos);
        }
    }

    private static void putBulkData(VertexConsumer buffer, Matrix4f pose, BakedQuad bakedQuad, Vector3f color, Vector3f normal, Vector4f pos) {
        int[] vertices = bakedQuad.m_111303_();
        int vertexCount = vertices.length / DefaultVertexFormat.f_85811_.m_86017_();
        try (MemoryStack memorystack = MemoryStack.stackPush();){
            ByteBuffer bytebuffer = memorystack.malloc(DefaultVertexFormat.f_85811_.m_86020_());
            IntBuffer intbuffer = bytebuffer.asIntBuffer();
            for (int v = 0; v < vertexCount; ++v) {
                ((Buffer)intbuffer).clear();
                intbuffer.put(vertices, v * 8, 8);
                pos.set(bytebuffer.getFloat(0), bytebuffer.getFloat(4), bytebuffer.getFloat(8), 1.0f);
                pos.mul((Matrix4fc)pose);
                buffer.m_5483_((double)pos.x(), (double)pos.y(), (double)pos.z()).m_85950_(color.x(), color.y(), color.z(), 1.0f).m_5601_(normal.x(), normal.y(), normal.z()).m_5752_();
            }
        }
    }

    private static class BufferBuilderTransparent
    extends BufferBuilder {
        private float alphaPercentage;

        public BufferBuilderTransparent() {
            super(0x200000);
        }

        public void setAlphaPercentage(float alphaPercentage) {
            this.alphaPercentage = Mth.m_14036_((float)alphaPercentage, (float)0.0f, (float)1.0f);
        }

        public VertexConsumer m_6122_(int red, int green, int blue, int alpha) {
            return super.m_6122_(red, green, blue, (int)((float)alpha * this.alphaPercentage));
        }

        public void m_5954_(float x, float y, float z, float red, float green, float blue, float alpha, float texU, float texV, int overlayUV, int lightmapUV, float normalX, float normalY, float normalZ) {
            super.m_5954_(x, y, z, red, green, blue, alpha * this.alphaPercentage, texU, texV, overlayUV, lightmapUV, normalX, normalY, normalZ);
        }
    }
}

