/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client.render;

import com.communi.suggestu.scena.core.util.TransformationUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.Objects;
import java.util.UUID;
import mod.chiselsandbits.api.measuring.IMeasurement;
import mod.chiselsandbits.api.measuring.MeasuringMode;
import mod.chiselsandbits.api.measuring.MeasuringType;
import mod.chiselsandbits.api.util.VectorUtils;
import mod.chiselsandbits.client.render.ModRenderTypes;
import mod.chiselsandbits.measures.MeasuringManager;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Team;
import org.joml.Vector3f;

public final class MeasurementRenderer {
    private static final MeasurementRenderer INSTANCE = new MeasurementRenderer();

    private MeasurementRenderer() {
    }

    public static MeasurementRenderer getInstance() {
        return INSTANCE;
    }

    public void renderMeasurements(PoseStack poseStack) {
        if (Minecraft.m_91087_().f_91073_ == null) {
            return;
        }
        Collection<? extends IMeasurement> measurements = MeasuringManager.getInstance().getInWorld((Level)Minecraft.m_91087_().f_91073_);
        Vec3 vector3d = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        double xView = vector3d.m_7096_();
        double yView = vector3d.m_7098_();
        double zView = vector3d.m_7094_();
        measurements.forEach(measurement -> {
            Vec3 startPos = measurement.getFrom();
            AABB measurementBB = new AABB(Vec3.f_82478_, measurement.getSize().m_82520_(1.0E-4, 1.0E-4, 1.0E-4));
            VoxelShape boundingShape = Shapes.m_83064_((AABB)measurementBB);
            if (measurement.getMode().getGroup().map(g -> g != MeasuringType.DISTANCE).orElse(false).booleanValue()) {
                LevelRenderer.m_109782_((PoseStack)poseStack, (VertexConsumer)Minecraft.m_91087_().m_91269_().m_110104_().m_6299_(ModRenderTypes.MEASUREMENT_LINES.get()), (VoxelShape)boundingShape, (double)(startPos.m_7096_() - xView), (double)(startPos.m_7098_() - yView), (double)(startPos.m_7094_() - zView), (float)((float)measurement.getMode().getColorVector().m_7096_()), (float)((float)measurement.getMode().getColorVector().m_7098_()), (float)((float)measurement.getMode().getColorVector().m_7094_()), (float)((float)measurement.getMode().getAlphaChannel()));
                Vec3 lengths = VectorUtils.absolute(measurement.getTo().m_82546_(measurement.getFrom()));
                Vec3 centerPos = measurement.getFrom().m_82549_(measurement.getTo()).m_82542_(0.5, 0.5, 0.5);
                if (lengths.m_7098_() > 0.0625) {
                    this.renderMeasurementSize(poseStack, (IMeasurement)measurement, lengths.m_7098_(), new Vec3(measurement.getFrom().m_7096_(), centerPos.m_7098_(), measurement.getFrom().m_7094_()));
                }
                if (lengths.m_7096_() > 0.0625) {
                    this.renderMeasurementSize(poseStack, (IMeasurement)measurement, lengths.m_7096_(), new Vec3(centerPos.m_7096_(), measurement.getFrom().m_7098_(), measurement.getFrom().m_7094_()));
                }
                if (lengths.m_7094_() > 0.0625) {
                    this.renderMeasurementSize(poseStack, (IMeasurement)measurement, lengths.m_7094_(), new Vec3(measurement.getFrom().m_7096_(), measurement.getFrom().m_7098_(), centerPos.m_7094_()));
                }
            } else if (measurement.getMode().getGroup().map(g -> g == MeasuringType.DISTANCE).orElse(false).booleanValue()) {
                VertexConsumer bufferIn = Minecraft.m_91087_().m_91269_().m_110104_().m_6299_(ModRenderTypes.MEASUREMENT_LINES.get());
                bufferIn.m_252986_(poseStack.m_85850_().m_252922_(), (float)(measurement.getFrom().m_7096_() - xView), (float)(measurement.getFrom().m_7098_() - yView), (float)(measurement.getFrom().m_7094_() - zView)).m_85950_((float)measurement.getMode().getColorVector().m_7096_(), (float)measurement.getMode().getColorVector().m_7098_(), (float)measurement.getMode().getColorVector().m_7094_(), (float)measurement.getMode().getAlphaChannel()).m_252939_(poseStack.m_85850_().m_252943_(), 0.0f, 1.0f, 0.0f).m_5752_();
                bufferIn.m_252986_(poseStack.m_85850_().m_252922_(), (float)(measurement.getTo().m_7096_() - xView), (float)(measurement.getTo().m_7098_() - yView), (float)(measurement.getTo().m_7094_() - zView)).m_85950_((float)measurement.getMode().getColorVector().m_7096_(), (float)measurement.getMode().getColorVector().m_7098_(), (float)measurement.getMode().getColorVector().m_7094_(), (float)measurement.getMode().getAlphaChannel()).m_252939_(poseStack.m_85850_().m_252943_(), 0.0f, 1.0f, 0.0f).m_5752_();
                Vec3 lengths = VectorUtils.absolute(measurement.getTo().m_82546_(measurement.getFrom()));
                double totalLength = lengths.m_82553_();
                Vec3 centerPos = measurement.getFrom().m_82549_(measurement.getTo()).m_82542_(0.5, 0.5, 0.5);
                if (totalLength > 0.0625) {
                    this.renderMeasurementSize(poseStack, (IMeasurement)measurement, totalLength, centerPos);
                }
            }
            Minecraft.m_91087_().m_91269_().m_110104_().m_109912_(ModRenderTypes.MEASUREMENT_LINES.get());
        });
    }

    private void renderMeasurementSize(PoseStack matrixStack, IMeasurement measurement, double length, Vec3 position) {
        double letterSize = 5.0;
        double zScale = 0.001;
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        Component size = this.formatLength(measurement.getMode(), length);
        Component owner = this.getOwnerName(measurement.getOwner());
        float scale = this.getScale(length);
        Vec3 vector3d = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        double xView = vector3d.m_7096_();
        double yView = vector3d.m_7098_();
        double zView = vector3d.m_7094_();
        matrixStack.m_85836_();
        matrixStack.m_85837_(position.m_7096_() - xView, position.m_7098_() + (double)scale * 5.0 - yView, position.m_7094_() - zView);
        this.performBillboardRotations(matrixStack);
        matrixStack.m_85841_(scale, -scale, 0.001f);
        matrixStack.m_85837_((double)(-fontRenderer.m_92852_((FormattedText)size)) * 0.5, 0.0, 0.0);
        RenderSystem.m_69465_();
        MultiBufferSource.BufferSource buffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        fontRenderer.m_252905_(size.getString(), 0.0f, 0.0f, measurement.getMode().getColor().m_41071_(), false, matrixStack.m_85850_().m_252922_(), (MultiBufferSource)buffer, true, 0, 0xF000F0);
        double d = (double)(-fontRenderer.m_92852_((FormattedText)owner)) * 0.5;
        Objects.requireNonNull(fontRenderer);
        matrixStack.m_85837_(d, (double)(-9), 0.0);
        fontRenderer.m_252905_(owner.getString(), 0.0f, 0.0f, measurement.getMode().getColor().m_41071_(), false, matrixStack.m_85850_().m_252922_(), (MultiBufferSource)buffer, true, 0, 0xF000F0);
        buffer.m_109911_();
        RenderSystem.m_69482_();
        matrixStack.m_85849_();
    }

    private Component formatLength(MeasuringMode mode, double length) {
        MeasuringType type = mode.getType();
        if (type == MeasuringType.DISTANCE) {
            return Component.m_237113_((String)new DecimalFormat("#.0#").format(length));
        }
        if (type == MeasuringType.BLOCK) {
            return Component.m_237110_((String)"chiselsandbits.measurements.lengths.block", (Object[])new Object[]{new DecimalFormat("#").format(Math.floor(length + 1.0))});
        }
        return Component.m_237110_((String)"chiselsandbits.measurements.lengths.bit", (Object[])new Object[]{new DecimalFormat("#").format(Math.floor(length * 16.0))});
    }

    private float getScale(double maxLen) {
        double maxFontSize = 0.04;
        double minFontSize = 0.004;
        double delta = Math.min(1.0, maxLen / 4.0);
        double scale = 0.04 * delta + 0.004 * (1.0 - delta);
        if (maxLen < 0.25) {
            scale = 0.004;
        }
        return (float)Math.min(0.04, scale);
    }

    private void performBillboardRotations(PoseStack matrixStack) {
        Entity view;
        Object object = view = Minecraft.m_91087_().f_91075_ != null ? Minecraft.m_91087_().f_91075_ : Minecraft.m_91087_().f_91074_;
        if (view != null) {
            float yaw = view.f_19859_ + (view.m_146908_() - view.f_19859_) * Minecraft.m_91087_().m_91296_();
            matrixStack.m_252781_(TransformationUtils.quatFromXYZ((Vector3f)new Vector3f(0.0f, 180.0f - yaw, 0.0f), (boolean)true));
            float pitch = view.f_19860_ + (view.m_146909_() - view.f_19860_) * Minecraft.m_91087_().m_91296_();
            matrixStack.m_252781_(TransformationUtils.quatFromXYZ((Vector3f)new Vector3f(-pitch, 0.0f, 0.0f), (boolean)true));
        }
    }

    private Component getOwnerName(UUID id) {
        PlayerInfo playerInfo;
        if (id == (Minecraft.m_91087_().f_91074_ != null ? Minecraft.m_91087_().f_91074_.m_20148_() : UUID.randomUUID())) {
            return Component.m_237115_((String)"chiselsandbits.measurements.owners.you");
        }
        PlayerInfo playerInfo2 = playerInfo = Minecraft.m_91087_().m_91403_() != null ? Minecraft.m_91087_().m_91403_().m_104949_(id) : null;
        if (playerInfo == null) {
            return Component.m_237115_((String)"chiselsandbits.measurements.owners.unknown");
        }
        return Component.m_237110_((String)"chiselsandbits.measurements.owners.by", (Object[])new Object[]{playerInfo.m_105342_() != null ? this.formatPlayerDisplayName(playerInfo, playerInfo.m_105342_().m_6881_()) : this.formatPlayerDisplayName(playerInfo, PlayerTeam.m_83348_((Team)playerInfo.m_105340_(), (Component)Component.m_237113_((String)playerInfo.m_105312_().getName())))});
    }

    private Component formatPlayerDisplayName(PlayerInfo p_238524_1_, MutableComponent p_238524_2_) {
        return p_238524_1_.m_105325_() == GameType.SPECTATOR ? p_238524_2_.m_130940_(ChatFormatting.ITALIC) : p_238524_2_;
    }
}

