/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client.screens.widgets;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import mod.chiselsandbits.ChiselsAndBits;
import mod.chiselsandbits.api.client.screen.AbstractChiselsAndBitsScreen;
import mod.chiselsandbits.api.client.screen.widget.AbstractChiselsAndBitsWidget;
import mod.chiselsandbits.api.item.withmode.IRenderableMode;
import mod.chiselsandbits.api.item.withmode.IToolMode;
import mod.chiselsandbits.api.item.withmode.IWithModeItem;
import mod.chiselsandbits.api.item.withmode.group.IToolModeGroup;
import mod.chiselsandbits.api.util.LocalStrings;
import mod.chiselsandbits.client.screens.widgets.RadialSelectionWidget;
import mod.chiselsandbits.network.packets.HeldToolModeChangedPacket;
import mod.chiselsandbits.utils.ItemStackUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ToolModeSelectionWidget<M extends IToolMode<G>, G extends IToolModeGroup>
extends AbstractChiselsAndBitsWidget {
    private static final int PAGE_SIZE = 6;
    private static final int PAGING_WIDGET_SIZE = 35;
    private static final float FULL_ROTATION_IN_DEGREES = 360.0f;
    private static final float HALF_ROTATION_IN_DEGREES = 180.0f;
    private static final float NO_ROTATION_IN_DEGREES = 0.0f;
    private static final float PAGING_INNER_SELECTION_RADIUS = 0.0f;
    private static final float PAGING_OUTER_SELECTION_RADIUS = 35.0f;
    private static final float PAGING_INNER_RENDERING_RADIUS = 0.0f;
    private static final float PAGING_OUTER_RENDERING_RADIUS = 35.0f;
    private static final boolean DISCARD_SELECTION_OUTSIDE_OF_AREA = false;
    private static final float DEFAULT_ICON_SIZE = 16.0f;
    private static final float NO_ICON_SCALING_FACTOR = 1.0f;
    private static final int DEFAULT_ICON_NAME_SPACER = 6;
    private static final int MAIN_WIDGET_SIZE = 80;
    private static final float MAIN_TORUS_INNER = 40.0f;
    private static final float MAIN_TORUS_OUTER = 80.0f;
    private static final boolean KEEP_SELECTION_OUTSIDE_OF_AREA = true;
    private static final int OUTER_WIDGET_SIZE = 120;
    private static final float OUTER_TORUS_INNER = 85.0f;
    private static final float OUTER_TORUS_OUTER = 120.0f;
    private static final float OUTER_TORUS_ICON_SCALE_FACTOR = 0.8f;
    private static final int OUTER_DEFAULT_ICON_TEXT_SPACER = 2;
    private static final boolean SHOW_INACTIVE_MODES = false;
    private static final boolean HIDE_INACTIVE_MODES = true;
    private final AbstractChiselsAndBitsScreen owner;
    private final IWithModeItem<M> toolModeItem;
    private final ItemStack sourceStack;
    private final List<M> modes = new ArrayList<M>();
    private final LinkedList<List<IRenderableMode>> pages = new LinkedList();
    private int currentPageIndex = 0;
    private final List<M> noneGroupedModes = new ArrayList<M>();
    private final Map<G, List<M>> groupings = new HashMap<G, List<M>>();
    private RadialSelectionWidget pageSelectionWidget = null;
    private final PageSelectionMode previousMode = new PageSelectionMode(true);
    private final PageSelectionMode nextMode = new PageSelectionMode(false);
    private final List<IRenderableMode> pagingModes = Lists.newArrayList((Object[])new IRenderableMode[]{this.nextMode, this.previousMode});
    private RadialSelectionWidget currentPageSelectionWidget = null;
    private List<IRenderableMode> page = new LinkedList<IRenderableMode>();
    private IRenderableMode currentHoveredPage = null;
    private RadialSelectionWidget currentGroupSelectionWidget = null;
    private final List<M> group = new LinkedList<M>();
    private IRenderableMode lastFrameMainSelectedToolMode;
    private IRenderableMode mainSelectedToolMode;
    private M selectedOuterToolMode;

    public ToolModeSelectionWidget(AbstractChiselsAndBitsScreen screen, IWithModeItem<M> toolModeItem, ItemStack sourceStack) {
        super(screen.f_96543_ / 2 - Math.min(screen.f_96543_, screen.f_96544_) / 2, screen.f_96544_ / 2 - Math.min(screen.f_96543_, screen.f_96544_) / 2, Math.min(screen.f_96543_, screen.f_96544_), Math.min(screen.f_96543_, screen.f_96544_), (Component)LocalStrings.ToolMenuSelectorName.getText(sourceStack.m_41611_()));
        this.owner = screen;
        this.toolModeItem = toolModeItem;
        this.sourceStack = sourceStack;
    }

    @Override
    public void init() {
        super.init();
        this.modes.clear();
        this.modes.addAll(this.toolModeItem.getPossibleModes());
        this.modes.stream().filter(mode -> mode.getGroup().isPresent()).forEach(mode -> this.groupings.computeIfAbsent((IToolModeGroup)mode.getGroup().get(), group -> Lists.newArrayList()).add(mode));
        this.modes.stream().filter(mode -> !mode.getGroup().isPresent()).forEach(this.noneGroupedModes::add);
        ArrayList<Object> allPagesCombined = new ArrayList<Object>();
        allPagesCombined.addAll(this.groupings.keySet());
        allPagesCombined.addAll(this.noneGroupedModes);
        allPagesCombined.sort(Comparator.comparingInt(renderableMode -> {
            if (this.noneGroupedModes.contains(renderableMode)) {
                return this.modes.indexOf(renderableMode);
            }
            return this.modes.indexOf(this.groupings.get((IToolModeGroup)renderableMode).iterator().next());
        }));
        if (allPagesCombined.isEmpty()) {
            return;
        }
        while (!allPagesCombined.isEmpty()) {
            LinkedList<IRenderableMode> page = new LinkedList<IRenderableMode>();
            for (int i = 0; i < 6; ++i) {
                if (allPagesCombined.isEmpty()) continue;
                page.add((IRenderableMode)allPagesCombined.remove(0));
            }
            this.pages.addLast(page);
        }
        this.rebuildPagingControl();
        this.rebuildPageControl();
    }

    public void m_86412_(@NotNull PoseStack stack, int mouseX, int mouseY, float partialTickTime) {
    }

    private void nextPage() {
        if (!this.nextMode.isActive()) {
            return;
        }
        ++this.currentPageIndex;
        this.rebuildPagingControl();
        this.rebuildPageControl();
    }

    private void previousPage() {
        if (!this.previousMode.isActive()) {
            return;
        }
        --this.currentPageIndex;
        this.rebuildPagingControl();
        this.rebuildPageControl();
    }

    private void rebuildPagingControl() {
        this.removePagingControl();
        this.pageSelectionWidget = this.owner.m_142416_(new RadialSelectionWidget(this, 35, 35, (Component)LocalStrings.ToolMenuPageSelectorName.getText(), () -> this.currentHoveredPage, this::onPageSelectorHover, this::onPageSelected, this.pagingModes, 360.0f, 0.0f, true, 0.0f, 35.0f, false, 0.0f, 35.0f, 16.0f, 1.0f, 6, this.getFont()));
        if (this.pages.size() == 1) {
            this.pageSelectionWidget.f_93624_ = false;
            this.pageSelectionWidget.f_93623_ = false;
        }
    }

    private void rebuildPageControl() {
        this.removePageControl();
        this.mainSelectedToolMode = null;
        this.lastFrameMainSelectedToolMode = null;
        this.selectedOuterToolMode = null;
        this.page = this.pages.get(this.currentPageIndex);
        this.currentPageSelectionWidget = this.owner.m_142416_(new RadialSelectionWidget(this, 80, 80, (Component)LocalStrings.ToolMenuGroupSelectorName.getText(), () -> this.mainSelectedToolMode, this::onMainToolModeHover, this::onMainToolModeClick, this.page, 360.0f, 0.0f, false, 40.0f, 80.0f, true, 40.0f, 80.0f, 16.0f, 1.0f, 6, this.getFont()));
    }

    private void rebuildGroupControl() {
        this.removeGroupWidget();
        if (this.selectedOuterToolMode != null && this.mainSelectedToolMode instanceof IToolModeGroup) {
            this.currentGroupSelectionWidget = this.owner.m_142416_(new RadialSelectionWidget(this, 120, 120, (Component)LocalStrings.ToolMenuModeSelectorName.getText(), () -> this.selectedOuterToolMode, this::onGroupedToolModeHover, this::onGroupedToolModeClick, this.groupings.get(this.mainSelectedToolMode), 180.0f, this.page.indexOf(this.mainSelectedToolMode) < Math.min(6, this.page.size()) / 2 ? 0.0f : 180.0f, false, 85.0f, 120.0f, false, 85.0f, 120.0f, 16.0f, 0.8f, 2, this.getFont()));
        }
    }

    private void removePagingControl() {
        if (this.pageSelectionWidget == null) {
            return;
        }
        this.removeWidget(this.pageSelectionWidget);
    }

    private void removePageControl() {
        if (this.currentPageSelectionWidget == null) {
            return;
        }
        this.removeWidget(this.currentPageSelectionWidget);
    }

    private void removeGroupWidget() {
        if (this.currentGroupSelectionWidget == null) {
            return;
        }
        this.removeWidget(this.currentGroupSelectionWidget);
    }

    private void removeWidget(GuiEventListener widget) {
        this.owner.m_169411_(widget);
    }

    private void onPageSelected(IRenderableMode iRenderableMode) {
        if (iRenderableMode == this.nextMode) {
            this.nextPage();
        } else {
            this.previousPage();
        }
    }

    private void onPageSelectorHover(IRenderableMode mode) {
        this.currentHoveredPage = mode;
    }

    private void onMainToolModeHover(IRenderableMode mode) {
        this.mainSelectedToolMode = mode;
        if (this.lastFrameMainSelectedToolMode == null && this.mainSelectedToolMode == null) {
            this.rebuildGroupControl();
            return;
        }
        if (this.lastFrameMainSelectedToolMode != null && this.mainSelectedToolMode == null) {
            this.lastFrameMainSelectedToolMode = null;
            this.selectedOuterToolMode = null;
            this.rebuildGroupControl();
            return;
        }
        if ((this.lastFrameMainSelectedToolMode == null || this.lastFrameMainSelectedToolMode != this.mainSelectedToolMode) && this.mainSelectedToolMode instanceof IToolModeGroup) {
            this.lastFrameMainSelectedToolMode = this.mainSelectedToolMode;
            this.selectedOuterToolMode = (IToolMode)this.groupings.get((IToolModeGroup)this.mainSelectedToolMode).get(0);
            this.rebuildGroupControl();
            return;
        }
        if (this.mainSelectedToolMode instanceof IToolMode) {
            this.lastFrameMainSelectedToolMode = this.mainSelectedToolMode;
            this.selectedOuterToolMode = null;
            this.rebuildGroupControl();
        }
    }

    private void onMainToolModeClick(IRenderableMode mode) {
        this.onMainToolModeHover(mode);
        if (!(mode instanceof IToolModeGroup)) {
            this.mainSelectedToolMode = mode;
            this.updateSelection();
            this.owner.m_7379_();
        }
    }

    private void onGroupedToolModeHover(IRenderableMode mode) {
        this.selectedOuterToolMode = (IToolMode)mode;
    }

    private void onGroupedToolModeClick(IRenderableMode mode) {
        this.mainSelectedToolMode = mode;
        this.updateSelection();
        this.owner.m_7379_();
    }

    @Override
    public void removed() {
        if (this.toolModeItem.requiresUpdateOnClosure()) {
            this.updateSelection();
        }
    }

    public void updateSelection() {
        if (this.mainSelectedToolMode != null) {
            M mainToolModeSelection = this.mainSelectedToolMode instanceof IToolModeGroup ? this.selectedOuterToolMode : (this.mainSelectedToolMode instanceof IToolMode ? (IToolMode)this.mainSelectedToolMode : this.toolModeItem.getMode(this.sourceStack));
            this.toolModeItem.setMode(ItemStackUtils.getModeItemStackFromPlayer((Player)Minecraft.m_91087_().f_91074_), mainToolModeSelection);
            ChiselsAndBits.getInstance().getNetworkChannel().sendToServer(new HeldToolModeChangedPacket(this.modes.indexOf(mainToolModeSelection)));
        }
    }

    protected boolean m_7972_(int button) {
        return false;
    }

    private final class PageSelectionMode
    implements IRenderableMode {
        private final boolean isPrevious;

        private PageSelectionMode(boolean isPrevious) {
            this.isPrevious = isPrevious;
        }

        @Override
        @NotNull
        public ResourceLocation getIcon() {
            return this.isPrevious ? new ResourceLocation("chiselsandbits", "textures/icons/undo.png") : new ResourceLocation("chiselsandbits", "textures/icons/redo.png");
        }

        @Override
        public Component getDisplayName() {
            return this.isPrevious ? LocalStrings.ToolMenuPreviousPageName.getText() : LocalStrings.ToolMenuNextPageName.getText();
        }

        @Override
        public boolean isActive() {
            return this.isPrevious ? ToolModeSelectionWidget.this.currentPageIndex != 0 : ToolModeSelectionWidget.this.currentPageIndex != ToolModeSelectionWidget.this.pages.size() - 1;
        }
    }
}

