/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.config;

import com.communi.suggestu.scena.core.config.ConfigurationType;
import com.communi.suggestu.scena.core.config.IConfigurationBuilder;
import com.communi.suggestu.scena.core.config.IConfigurationManager;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Supplier;
import mod.chiselsandbits.api.client.render.preview.placement.PlacementPreviewRenderMode;
import mod.chiselsandbits.api.config.IClientConfiguration;
import org.joml.Vector4f;

public class ClientConfiguration
implements IClientConfiguration {
    private final Supplier<Boolean> bitBagFullness;
    private final Supplier<PlacementPreviewRenderMode> successfulPlacementRenderMode;
    private final Supplier<PlacementPreviewRenderMode> failedPlacementRenderMode;
    private final Supplier<Vector4f> successfulPlacementColor;
    private final Supplier<Vector4f> notFittingPatternPlacementColor;
    private final Supplier<Vector4f> missingBitsOrSpacePatternPlacementColor;
    private final Supplier<List<? extends Float>> previewChiselingColor;
    private final Supplier<List<? extends Float>> previewPlacementColor;
    private final Supplier<List<? extends Float>> mutatorPreviewChiselingColor;
    private final Supplier<List<? extends Float>> mutatorPreviewPlacementColor;
    private final Supplier<Boolean> mutatorPreviewDebug;
    private final Supplier<String> previewRenderer;
    private final Supplier<String> toolModeRenderer;
    private final Supplier<Boolean> invertPickBlockBehaviour;
    private final Supplier<Long> bitStorageContentCacheSize;
    private final Supplier<Boolean> faceLightMapExtraction;
    private final Supplier<Boolean> blockLightEmissionExtraction;
    private final Supplier<Boolean> radialMenuMouseIndicator;
    private final Supplier<Long> modelCacheSize;
    private final Supplier<Long> stackModelCacheSize;
    private final Supplier<Long> faceLayerCacheSize;
    private final Supplier<Integer> modelBuildingThreadCount;
    private final Supplier<Integer> clipboardSize;
    private final Supplier<Boolean> addBrokenBlocksToClipboard;
    private final Supplier<Boolean> addPickedBlocksToClipboard;
    private final Supplier<String> patternExportPath;
    private final Supplier<Boolean> showCoolDownError;
    private final Supplier<Long> cullTestingCacheSize;

    public ClientConfiguration() {
        IConfigurationBuilder builder = IConfigurationManager.getInstance().createBuilder(ConfigurationType.CLIENT_ONLY, "chiselsandbits-client");
        this.bitBagFullness = builder.defineBoolean("settings.bit-bag.invert-durability-bar-indication", false);
        this.successfulPlacementRenderMode = builder.defineEnum("settings.placement.render-mode.success", (Enum)PlacementPreviewRenderMode.GHOST_BLOCK_MODEL);
        this.failedPlacementRenderMode = builder.defineEnum("settings.placement.render-mode.failed", (Enum)PlacementPreviewRenderMode.GHOST_BLOCK_MODEL_SOLID_COLOR);
        this.successfulPlacementColor = builder.defineVector4f("settings.placement.color.success", new Vector4f(0.1882353f, 0.47058824f, 0.7882353f, 0.7058824f));
        this.notFittingPatternPlacementColor = builder.defineVector4f("settings.placement.color.not-fitting", new Vector4f(0.7176471f, 0.25490198f, 0.05490196f, 0.7058824f));
        this.missingBitsOrSpacePatternPlacementColor = builder.defineVector4f("settings.placement.color.missing-bits-or-space", new Vector4f(1.0f, 0.85882354f, 0.34509805f, 0.7058824f));
        this.previewChiselingColor = builder.defineList("settings.chiseling-previews.default.colors.chiseling", (List)Lists.newArrayList((Object[])new Float[]{Float.valueOf(0.85f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.65f)}), Float.class);
        this.previewPlacementColor = builder.defineList("settings.chiseling-previews.default.colors.placement", (List)Lists.newArrayList((Object[])new Float[]{Float.valueOf(0.0f), Float.valueOf(0.85f), Float.valueOf(0.0f), Float.valueOf(0.65f)}), Float.class);
        this.previewRenderer = builder.defineString("settings.chiseling-previews.renderer", "chiselsandbits:default");
        this.mutatorPreviewDebug = builder.defineBoolean("settings.chiseling-previews.debug.enabled", false);
        this.mutatorPreviewChiselingColor = builder.defineList("settings.chiseling-previews.debug.mutator.colors.chiseling", (List)Lists.newArrayList((Object[])new Float[]{Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.85f), Float.valueOf(0.65f)}), Float.class);
        this.mutatorPreviewPlacementColor = builder.defineList("settings.chiseling-previews.debug.mutator.colors.placement", (List)Lists.newArrayList((Object[])new Float[]{Float.valueOf(0.85f), Float.valueOf(0.85f), Float.valueOf(0.0f), Float.valueOf(0.65f)}), Float.class);
        this.toolModeRenderer = builder.defineString("settings.selected-tool-mode-icons.renderer", "chiselsandbits:group");
        this.invertPickBlockBehaviour = builder.defineBoolean("settings.invert-pick-block-behaviour", false);
        this.clipboardSize = builder.defineInteger("settings.clipboard.size", 64, 0, 64);
        this.addBrokenBlocksToClipboard = builder.defineBoolean("settings.clipboard.add-broken-blocks", true);
        this.addPickedBlocksToClipboard = builder.defineBoolean("settings.clipboard.add-picked-blocks", true);
        this.patternExportPath = builder.defineString("settings.patterns.export-path", "./chiselsandbits/patterns");
        this.bitStorageContentCacheSize = builder.defineLong("performance.caches.sizes.bit-storage-content-models", 100L, 0L, Long.MAX_VALUE);
        this.faceLightMapExtraction = builder.defineBoolean("performance.lighting.extract-lighting-values-from-faces", true);
        this.blockLightEmissionExtraction = builder.defineBoolean("performance.lighting.extract-lighting-values-from-blockstates", false);
        this.radialMenuMouseIndicator = builder.defineBoolean("gui.radial-menu.display-mouse-indicator", false);
        this.modelCacheSize = builder.defineLong("performance.caches.sizes.block-models", 1000L, 3500L, 20000L);
        this.faceLayerCacheSize = builder.defineLong("performance.caches.sizes.block-faces", 1000000L, 350000L, 2000000L);
        this.cullTestingCacheSize = builder.defineLong("performance.caches.sizes.cull-testing", 1000L, 3500L, 200000L);
        this.modelBuildingThreadCount = builder.defineInteger("performance.model-building.thread-count", Math.max(1, Runtime.getRuntime().availableProcessors()) / 2, 1, Runtime.getRuntime().availableProcessors());
        this.stackModelCacheSize = builder.defineLong("performance.caches.sizes.stack-models", 100L, 0L, Long.MAX_VALUE);
        this.showCoolDownError = builder.defineBoolean("settings.warnings.show-cool-down-error", false);
        builder.setup();
    }

    @Override
    public Supplier<Boolean> getInvertBitBagFullness() {
        return this.bitBagFullness;
    }

    @Override
    public Supplier<PlacementPreviewRenderMode> getSuccessfulPlacementRenderMode() {
        return this.successfulPlacementRenderMode;
    }

    @Override
    public Supplier<PlacementPreviewRenderMode> getFailedPlacementRenderMode() {
        return this.failedPlacementRenderMode;
    }

    @Override
    public Supplier<Vector4f> getSuccessfulPlacementColor() {
        return this.successfulPlacementColor;
    }

    @Override
    public Supplier<Vector4f> getNotFittingPatternPlacementColor() {
        return this.notFittingPatternPlacementColor;
    }

    @Override
    public Supplier<Vector4f> getMissingBitsOrSpacePatternPlacementColor() {
        return this.missingBitsOrSpacePatternPlacementColor;
    }

    @Override
    public Supplier<List<? extends Float>> getPreviewChiselingColor() {
        return this.previewChiselingColor;
    }

    @Override
    public Supplier<List<? extends Float>> getPreviewPlacementColor() {
        return this.previewPlacementColor;
    }

    @Override
    public Supplier<String> getPreviewRenderer() {
        return this.previewRenderer;
    }

    @Override
    public Supplier<String> getToolModeRenderer() {
        return this.toolModeRenderer;
    }

    @Override
    public Supplier<Boolean> getInvertPickBlockBehaviour() {
        return this.invertPickBlockBehaviour;
    }

    @Override
    public Supplier<Long> getBitStorageContentCacheSize() {
        return this.bitStorageContentCacheSize;
    }

    @Override
    public Supplier<Boolean> getEnableFaceLightmapExtraction() {
        return this.faceLightMapExtraction;
    }

    @Override
    public Supplier<Boolean> getUseGetLightValue() {
        return this.blockLightEmissionExtraction;
    }

    @Override
    public Supplier<Boolean> getEnableMouseIndicatorInRadialMenu() {
        return this.radialMenuMouseIndicator;
    }

    @Override
    public Supplier<Long> getModelCacheSize() {
        return this.modelCacheSize;
    }

    @Override
    public Supplier<Long> getFaceLayerCacheSize() {
        return this.faceLayerCacheSize;
    }

    @Override
    public Supplier<Integer> getModelBuildingThreadCount() {
        return this.modelBuildingThreadCount;
    }

    @Override
    public Supplier<Integer> getClipboardSize() {
        return this.clipboardSize;
    }

    @Override
    public Supplier<Boolean> getShouldBrokenBlocksBeAddedToClipboard() {
        return this.addBrokenBlocksToClipboard;
    }

    @Override
    public Supplier<Boolean> getShouldPickedBlocksBeAddedToClipboard() {
        return this.addPickedBlocksToClipboard;
    }

    @Override
    public Supplier<String> getPatternExportPath() {
        return this.patternExportPath;
    }

    @Override
    public Supplier<Long> getStackModelCacheSize() {
        return this.stackModelCacheSize;
    }

    @Override
    public Supplier<Long> getCullTestingCacheSize() {
        return this.cullTestingCacheSize;
    }

    @Override
    public Supplier<List<? extends Float>> getMutatorPreviewChiselingColor() {
        return this.mutatorPreviewChiselingColor;
    }

    @Override
    public Supplier<List<? extends Float>> getMutatorPreviewPlacementColor() {
        return this.mutatorPreviewPlacementColor;
    }

    @Override
    public Supplier<Boolean> getMutatorPreviewDebug() {
        return this.mutatorPreviewDebug;
    }

    @Override
    public Supplier<Boolean> getShowCoolDownError() {
        return this.showCoolDownError;
    }
}

