/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.item;

import com.communi.suggestu.scena.core.registries.ICustomRegistryEntry;
import java.util.Collection;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import mod.chiselsandbits.api.block.entity.IMultiStateBlockEntity;
import mod.chiselsandbits.api.change.IChangeTrackerManager;
import mod.chiselsandbits.api.item.click.ClickProcessingState;
import mod.chiselsandbits.api.item.click.IRightClickControllingItem;
import mod.chiselsandbits.api.item.withmode.IWithModeItem;
import mod.chiselsandbits.api.modification.operation.IModificationOperation;
import mod.chiselsandbits.api.util.IBatchMutation;
import mod.chiselsandbits.api.util.RayTracingUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class WrenchItem
extends Item
implements IWithModeItem<IModificationOperation>,
IRightClickControllingItem {
    private static final Logger LOGGER = LogManager.getLogger();

    public WrenchItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    @NotNull
    public IModificationOperation getMode(ItemStack stack) {
        CompoundTag stackNbt = stack.m_41784_();
        if (stackNbt.m_128441_("modificationMode")) {
            String modeName = stackNbt.m_128461_("modificationMode");
            try {
                Optional registryMode = IModificationOperation.getRegistry().get(new ResourceLocation(modeName));
                return registryMode.orElseGet(IModificationOperation::getDefaultMode);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LOGGER.error(String.format("An ItemStack got loaded with a name that is not a valid modification mode: %s", modeName));
                this.setMode(stack, IModificationOperation.getDefaultMode());
            }
        }
        return IModificationOperation.getDefaultMode();
    }

    @Override
    public void setMode(ItemStack stack, IModificationOperation mode) {
        if (mode == null) {
            return;
        }
        stack.m_41784_().m_128359_("modificationMode", Objects.requireNonNull(mode.getRegistryName()).toString());
    }

    @Override
    @NotNull
    public Collection<IModificationOperation> getPossibleModes() {
        return IModificationOperation.getRegistry().getValues().stream().sorted(Comparator.comparing(ICustomRegistryEntry::getRegistryName)).collect(Collectors.toList());
    }

    @Override
    public boolean canUse(Player playerEntity, ItemStack stack) {
        BlockHitResult blockHitResult;
        block3: {
            block2: {
                HitResult result = RayTracingUtils.rayTracePlayer(playerEntity);
                if (!(result instanceof BlockHitResult)) break block2;
                blockHitResult = (BlockHitResult)result;
                if (result.m_6662_() == HitResult.Type.BLOCK) break block3;
            }
            return false;
        }
        BlockEntity blockEntity = playerEntity.f_19853_.m_7702_(blockHitResult.m_82425_());
        return blockEntity instanceof IMultiStateBlockEntity;
    }

    @Override
    public ClickProcessingState handleRightClickProcessing(Player playerEntity, InteractionHand hand, BlockPos position, Direction face, ClickProcessingState currentState) {
        BlockHitResult blockHitResult;
        block12: {
            block11: {
                HitResult result = RayTracingUtils.rayTracePlayer(playerEntity);
                if (!(result instanceof BlockHitResult)) break block11;
                blockHitResult = (BlockHitResult)result;
                if (result.m_6662_() == HitResult.Type.BLOCK) break block12;
            }
            return ClickProcessingState.DENIED;
        }
        BlockEntity blockEntity = playerEntity.f_19853_.m_7702_(blockHitResult.m_82425_());
        if (!(blockEntity instanceof IMultiStateBlockEntity)) {
            return ClickProcessingState.DENIED;
        }
        IMultiStateBlockEntity multiStateBlockEntity = (IMultiStateBlockEntity)blockEntity;
        try (IBatchMutation ignored = multiStateBlockEntity.batch(IChangeTrackerManager.getInstance().getChangeTracker(playerEntity));){
            this.getMode(playerEntity.m_21120_(hand)).apply(multiStateBlockEntity);
        }
        return ClickProcessingState.ALLOW;
    }

    @Override
    public void onRightClickProcessingEnd(Player player, ItemStack stack) {
    }
}

