/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.neighborhood;

import java.util.EnumMap;
import java.util.Objects;
import mod.chiselsandbits.api.blockinformation.IBlockInformation;
import mod.chiselsandbits.api.multistate.accessor.IAreaAccessor;
import mod.chiselsandbits.api.neighborhood.IBlockNeighborhood;
import mod.chiselsandbits.neighborhood.BlockNeighborhoodEntry;
import net.minecraft.core.Direction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BlockNeighborhood
implements IBlockNeighborhood {
    private final EnumMap<Direction, BlockNeighborhoodEntry> neighborhoodMap;

    public BlockNeighborhood(EnumMap<Direction, BlockNeighborhoodEntry> neighborhoodMap) {
        this.neighborhoodMap = neighborhoodMap;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BlockNeighborhood)) {
            return false;
        }
        BlockNeighborhood that = (BlockNeighborhood)o;
        return Objects.equals(this.neighborhoodMap, that.neighborhoodMap);
    }

    public int hashCode() {
        return this.neighborhoodMap != null ? this.neighborhoodMap.hashCode() : 0;
    }

    @Override
    @NotNull
    public IBlockInformation getBlockInformation(Direction direction) {
        return this.neighborhoodMap.get(direction).getBlockInformation();
    }

    @Override
    @Nullable
    public IAreaAccessor getAreaAccessor(Direction direction) {
        if (!this.neighborhoodMap.containsKey(direction)) {
            return null;
        }
        return this.neighborhoodMap.get(direction).getAccessor();
    }
}

