/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.recipe;

import com.communi.suggestu.scena.core.item.IDyeItemHelper;
import mod.chiselsandbits.item.BitBagItem;
import mod.chiselsandbits.registrars.ModRecipeSerializers;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class BagDyeingRecipe
extends CustomRecipe {
    public BagDyeingRecipe(ResourceLocation name, CraftingBookCategory category) {
        super(name, category);
    }

    public boolean matches(@NotNull CraftingContainer inv, @NotNull Level worldIn) {
        return !this.getOutput(inv).getBag().m_41619_();
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingContainer inv) {
        Result output = this.getOutput(inv);
        if (!output.getBag().m_41619_()) {
            return BitBagItem.dyeBag(output.bag, output.color);
        }
        return ItemStack.f_41583_;
    }

    @NotNull
    private Result getOutput(CraftingContainer inv) {
        ItemStack bag = null;
        ItemStack dye = null;
        for (int x = 0; x < inv.m_6643_(); ++x) {
            ItemStack is = inv.m_8020_(x);
            if (is.m_41619_()) continue;
            if (is.m_41720_() == Items.f_42447_ || this.getDye(is) != null) {
                if (dye == null) {
                    dye = is;
                    continue;
                }
                return Result.EMPTY;
            }
            if (is.m_41720_() instanceof BitBagItem) {
                if (bag == null) {
                    bag = is;
                    continue;
                }
                return Result.EMPTY;
            }
            return Result.EMPTY;
        }
        if (bag != null && dye != null) {
            return new Result(bag, this.getDye(dye));
        }
        return Result.EMPTY;
    }

    private DyeColor getDye(ItemStack is) {
        return IDyeItemHelper.getInstance().getColorFromItem(is).orElseGet(() -> {
            Item patt2851$temp = is.m_41720_();
            if (patt2851$temp instanceof DyeItem) {
                DyeItem item = (DyeItem)patt2851$temp;
                return item.m_41089_();
            }
            return null;
        });
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeSerializers.BAG_DYEING.get();
    }

    private static class Result {
        private static final Result EMPTY = new Result(ItemStack.f_41583_, DyeColor.WHITE);
        private final ItemStack bag;
        private final DyeColor color;

        public Result(ItemStack bag, DyeColor dye) {
            this.bag = bag;
            this.color = dye;
        }

        public ItemStack getBag() {
            return this.bag;
        }

        public DyeColor getColor() {
            return this.color;
        }
    }
}

