/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.registrars;

import com.communi.suggestu.scena.core.creativetab.ICreativeTabManager;
import com.communi.suggestu.scena.core.registries.IPlatformRegistryManager;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import mod.chiselsandbits.api.blockinformation.IBlockInformation;
import mod.chiselsandbits.api.chiseling.eligibility.IEligibilityManager;
import mod.chiselsandbits.api.client.clipboard.ICreativeClipboardManager;
import mod.chiselsandbits.api.item.bit.IBitItem;
import mod.chiselsandbits.api.item.bit.IBitItemManager;
import mod.chiselsandbits.api.item.multistate.IMultiStateItemStack;
import mod.chiselsandbits.api.util.LocalStrings;
import mod.chiselsandbits.api.variant.state.IStateVariantManager;
import mod.chiselsandbits.block.ChiseledBlock;
import mod.chiselsandbits.blockinformation.BlockInformation;
import mod.chiselsandbits.item.BitBagItem;
import mod.chiselsandbits.registrars.ModItems;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ModCreativeTabs {
    public static Supplier<CreativeModeTab> MAIN;
    public static Supplier<CreativeModeTab> BITS;
    public static Supplier<CreativeModeTab> CLIPBOARD;
    private static final Logger LOGGER;

    private ModCreativeTabs() {
        throw new IllegalStateException("Tried to initialize: ModItemGroups but this is a Utility class.");
    }

    public static void onModConstruction() {
        LOGGER.info("Loaded item group configuration.");
        MAIN = ICreativeTabManager.getInstance().register(builder -> {
            builder.m_257737_(() -> new ItemStack((ItemLike)ModItems.ITEM_CHISEL_NETHERITE.get()));
            builder.m_257941_((Component)LocalStrings.ChiselsAndBitsName.getText());
            builder.m_257501_((flags, output, permission) -> {
                output.m_246342_(new ItemStack((ItemLike)ModItems.ITEM_CHISEL_STONE.get()));
                output.m_246342_(new ItemStack((ItemLike)ModItems.ITEM_CHISEL_IRON.get()));
                output.m_246342_(new ItemStack((ItemLike)ModItems.ITEM_CHISEL_GOLD.get()));
                output.m_246342_(new ItemStack((ItemLike)ModItems.ITEM_CHISEL_DIAMOND.get()));
                output.m_246342_(new ItemStack((ItemLike)ModItems.ITEM_CHISEL_NETHERITE.get()));
                output.m_246342_(new ItemStack((ItemLike)ModItems.ITEM_BIT_BAG_DEFAULT.get()));
                for (DyeColor color : DyeColor.values()) {
                    output.m_246342_(BitBagItem.dyeBag(new ItemStack((ItemLike)ModItems.ITEM_BIT_BAG_DYED.get()), color));
                }
                output.m_246342_(new ItemStack((ItemLike)ModItems.MAGNIFYING_GLASS.get()));
                output.m_246342_(new ItemStack((ItemLike)ModItems.ITEM_BIT_STORAGE.get()));
                output.m_246342_(new ItemStack((ItemLike)ModItems.ITEM_MODIFICATION_TABLE.get()));
                output.m_246342_(new ItemStack((ItemLike)ModItems.MEASURING_TAPE.get()));
                output.m_246342_(new ItemStack((ItemLike)ModItems.SINGLE_USE_PATTERN_ITEM.get()));
                output.m_246342_(new ItemStack((ItemLike)ModItems.MULTI_USE_PATTERN_ITEM.get()));
                output.m_246342_(new ItemStack((ItemLike)ModItems.QUILL.get()));
                output.m_246342_(new ItemStack((ItemLike)ModItems.SEALANT_ITEM.get()));
                output.m_246342_(new ItemStack((ItemLike)ModItems.CHISELED_PRINTER.get()));
                output.m_246342_(new ItemStack((ItemLike)ModItems.MONOCLE_ITEM.get()));
            });
        }, new ResourceLocation("chiselsandbits", "main"), List.of(new ResourceLocation("spawn_eggs")), List.of());
        BITS = ICreativeTabManager.getInstance().register(builder -> {
            builder.m_257737_(() -> new ItemStack((ItemLike)ModItems.ITEM_BLOCK_BIT.get()));
            builder.m_257941_((Component)LocalStrings.CreativeTabBits.getText());
            builder.m_257623_(CreativeModeTab.Type.SEARCH);
            builder.m_257501_((flags, output, permissions) -> IPlatformRegistryManager.getInstance().getBlockRegistry().getValues().forEach(block -> {
                ItemStack resultStack;
                if (block instanceof ChiseledBlock) {
                    return;
                }
                BlockState blockState = block.m_49966_();
                Collection<IBlockInformation> defaultStateVariants = IStateVariantManager.getInstance().getAllDefaultVariants(blockState);
                if (!defaultStateVariants.isEmpty()) {
                    defaultStateVariants.forEach(blockInformation -> {
                        ItemStack resultStack = IBitItemManager.getInstance().create((IBlockInformation)blockInformation);
                        if (!resultStack.m_41619_() && resultStack.m_41720_() instanceof IBitItem) {
                            output.m_246342_(resultStack);
                        }
                    });
                    return;
                }
                BlockInformation information = new BlockInformation(blockState, Optional.empty());
                if (IEligibilityManager.getInstance().canBeChiseled(information) && !(resultStack = IBitItemManager.getInstance().create(information)).m_41619_() && resultStack.m_41720_() instanceof IBitItem) {
                    output.m_246342_(resultStack);
                }
            }));
        }, new ResourceLocation("chiselsandbits", "bits"), List.of(new ResourceLocation("chiselsandbits", "main")), List.of());
        CLIPBOARD = ICreativeTabManager.getInstance().register(builder -> {
            builder.m_257737_(() -> new ItemStack((ItemLike)ModItems.PATTERN_SCANNER.get()));
            builder.m_257941_((Component)LocalStrings.CreativeTabClipboard.getText());
            builder.m_257501_((flags, output, permissions) -> output.m_246601_(ICreativeClipboardManager.getInstance().getClipboard().stream().map(IMultiStateItemStack::toBlockStack).toList()));
        }, new ResourceLocation("chiselsandbits", "clipboard"), List.of(new ResourceLocation("chiselsandbits", "bits")), List.of());
    }

    static {
        LOGGER = LogManager.getLogger();
    }
}

